package com.biz.crm.activity.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activity.model.SfaActivityRangeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityRangeReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;

/**
 * 活动执行范围;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaActivityRangeService extends IService<SfaActivityRangeEntity> {

    /**
     * 列表
     * @param sfaActivityRangeReqVo
     * @return PageResult<SfaActivityRangeRespVo>
     */
    PageResult<SfaActivityRangeRespVo> findList(SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 查询
     * @param sfaActivityRangeReqVo
     * @return SfaActivityRangeRespVo
     */
    SfaActivityRangeRespVo query(SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 新增
     * @param sfaActivityRangeReqVo
     * @return
     */
    void save(SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 更新
     * @param sfaActivityRangeReqVo
     * @return
     */
    void update(SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 删除
     * @param sfaActivityRangeReqVo
     * @return
     */
    void deleteBatch(SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 启用
     * @param sfaActivityRangeReqVo
     * @return
     */
    void enableBatch(SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 禁用
     * @param sfaActivityRangeReqVo
     * @return
     */
    void disableBatch(SfaActivityRangeReqVo sfaActivityRangeReqVo);
}

