package com.biz.crm.activity.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityBgSetmealMapper;
import com.biz.crm.activity.model.SfaActivityBgSetmealEntity;
import com.biz.crm.activity.service.ISfaActivityBgSetmealService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityBgSetmealReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityBgSetmealRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 活动产品;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActivityBgSetmealServiceExpandImpl")
public class SfaActivityBgSetmealServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaActivityBgSetmealMapper, SfaActivityBgSetmealEntity> implements ISfaActivityBgSetmealService {

    @Resource
    private SfaActivityBgSetmealMapper sfaActivityBgSetmealMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActivityBgSetmealRespVo> findList(SfaActivityBgSetmealReqVo reqVo){
        Page<SfaActivityBgSetmealRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActivityBgSetmealRespVo> list = sfaActivityBgSetmealMapper.findList(page, reqVo);
        return PageResult.<SfaActivityBgSetmealRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return SfaActivityBgSetmealRespVo
     */
    @Override
    public SfaActivityBgSetmealRespVo query(SfaActivityBgSetmealReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActivityBgSetmealReqVo reqVo){
        SfaActivityBgSetmealEntity entity = CrmBeanUtil.copy(reqVo,SfaActivityBgSetmealEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActivityBgSetmealReqVo reqVo){
        SfaActivityBgSetmealEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActivityBgSetmealReqVo reqVo){
        List<SfaActivityBgSetmealEntity> sfaActivityBgSetmealEntities = sfaActivityBgSetmealMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityBgSetmealEntities)){
            sfaActivityBgSetmealEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActivityBgSetmealEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActivityBgSetmealReqVo reqVo){
        //设置状态为启用
        List<SfaActivityBgSetmealEntity> sfaActivityBgSetmealEntities = sfaActivityBgSetmealMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityBgSetmealEntities)){
            sfaActivityBgSetmealEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityBgSetmealEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActivityBgSetmealReqVo reqVo){
        //设置状态为禁用
        List<SfaActivityBgSetmealEntity> sfaActivityBgSetmealEntities = sfaActivityBgSetmealMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityBgSetmealEntities)){
            sfaActivityBgSetmealEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityBgSetmealEntities);
    }
}
