package com.biz.crm.activity.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityProductMapper;
import com.biz.crm.activity.model.SfaActivityProductEntity;
import com.biz.crm.activity.service.ISfaActivityProductService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityProductReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 活动产品;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActivityProductServiceExpandImpl")
public class SfaActivityProductServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaActivityProductMapper, SfaActivityProductEntity> implements ISfaActivityProductService {

    @Resource
    private SfaActivityProductMapper sfaActivityProductMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActivityProductRespVo> findList(SfaActivityProductReqVo reqVo){
        Page<SfaActivityProductRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActivityProductRespVo> list = sfaActivityProductMapper.findList(page, reqVo);
        return PageResult.<SfaActivityProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActivityProductRespVo
     */
    @Override
    public SfaActivityProductRespVo query(SfaActivityProductReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActivityProductReqVo reqVo){
        SfaActivityProductEntity entity = CrmBeanUtil.copy(reqVo,SfaActivityProductEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActivityProductReqVo reqVo){
        SfaActivityProductEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActivityProductReqVo reqVo){
        List<SfaActivityProductEntity> sfaActivityProductEntities = sfaActivityProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityProductEntities)){
            sfaActivityProductEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActivityProductEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActivityProductReqVo reqVo){
        //设置状态为启用
        List<SfaActivityProductEntity> sfaActivityProductEntities = sfaActivityProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityProductEntities)){
            sfaActivityProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityProductEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActivityProductReqVo reqVo){
        //设置状态为禁用
        List<SfaActivityProductEntity> sfaActivityProductEntities = sfaActivityProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityProductEntities)){
                sfaActivityProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityProductEntities);
    }
}
