package com.biz.crm.activity.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityRangeMapper;
import com.biz.crm.activity.model.SfaActivityRangeEntity;
import com.biz.crm.activity.service.ISfaActivityRangeService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityRangeReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 活动执行范围;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActivityRangeServiceExpandImpl")
public class SfaActivityRangeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaActivityRangeMapper, SfaActivityRangeEntity> implements ISfaActivityRangeService {

    @Resource
    private SfaActivityRangeMapper sfaActivityRangeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActivityRangeRespVo> findList(SfaActivityRangeReqVo reqVo){
        Page<SfaActivityRangeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActivityRangeRespVo> list = sfaActivityRangeMapper.findList(page, reqVo);
        return PageResult.<SfaActivityRangeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActivityRangeRespVo
     */
    @Override
    public SfaActivityRangeRespVo query(SfaActivityRangeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActivityRangeReqVo reqVo){
        SfaActivityRangeEntity entity = CrmBeanUtil.copy(reqVo,SfaActivityRangeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActivityRangeReqVo reqVo){
        SfaActivityRangeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActivityRangeReqVo reqVo){
        List<SfaActivityRangeEntity> sfaActivityRangeEntities = sfaActivityRangeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityRangeEntities)){
            sfaActivityRangeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActivityRangeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActivityRangeReqVo reqVo){
        //设置状态为启用
        List<SfaActivityRangeEntity> sfaActivityRangeEntities = sfaActivityRangeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityRangeEntities)){
            sfaActivityRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityRangeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActivityRangeReqVo reqVo){
        //设置状态为禁用
        List<SfaActivityRangeEntity> sfaActivityRangeEntities = sfaActivityRangeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityRangeEntities)){
                sfaActivityRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityRangeEntities);
    }
}
