package com.biz.crm.actscheme.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.actscheme.model.SfaActSchemeEntity;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemeReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动方案;
 * 
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface SfaActSchemeMapper extends BaseMapper<SfaActSchemeEntity> {
    /**
     * 列表
     * @param page
     * @param sfaActSchemeReqVo
     * @return
     */
    List<SfaActSchemeRespVo> findList(Page<SfaActSchemeRespVo> page, @Param("vo") SfaActSchemeReqVo sfaActSchemeReqVo);

    /**
     * 根据当前人员查询可申请的活动方案列表
     * @param page
     * @param sfaActSchemeReqVo
     * @return
     */
    List<SfaActSchemeRespVo> findPosList(Page<SfaActSchemeRespVo> page, @Param("vo") SfaActSchemeReqVo sfaActSchemeReqVo);


}
