package com.biz.crm.actscheme.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.actscheme.model.SfaActSchemePosApplyEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemePosApplyReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeTerminalRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsStopRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;

import java.util.List;

/**
 * 方案活动申请;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaActSchemePosApplyService extends IService<SfaActSchemePosApplyEntity> {

    /**
     * 列表
     *
     * @param sfaActSchemePosApplyReqVo
     * @return PageResult<SfaActSchemeRespVo>
     */
    PageResult<SfaActSchemePosApplyRespVo> findList(SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo);

    /**
     * 通过id查询详情
     *
     * @param id
     * @return
     */
    SfaActSchemePosApplyRespVo queryDetailById(String id);

    /**
     * 活动对应参与列表
     *
     * @param reqVo
     * @return
     */
    List<SfaAsStopRespVo> findAsStopList(SfaActSchemePosApplyReqVo reqVo);

    /**
     * 查询
     *
     * @param sfaActSchemePosApplyReqVo
     * @return SfaActSchemeRespVo
     */
    SfaActSchemePosApplyRespVo query(SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo);

    /**
     * 新增
     *
     * @param sfaActSchemePosApplyReqVo
     * @return
     */
    void save(SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo);

    /**
     * 更新
     *
     * @param sfaActSchemePosApplyReqVo
     * @return
     */
    void update(SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 结案
     *
     * @param ids
     */
    void endCase(List<String> ids);

    /**
     * 关闭
     *
     * @param ids
     */
    void close(List<String> ids);

    /**
     * 查询方案活动执行列表
     *
     * @param reqVo
     * @return
     */
    PageResult<SfaActivityExecutionRespVo> findActSchemeList(SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 查询方案活动执行完成列表
     *
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepActivityExecutionRespVo> findActSchemeCompleteList(SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 工作流审批回调
     *
     * @param activitiCallBackVo
     */
    void callback(ActivitiCallBackVo activitiCallBackVo);

    /**
     * 通过活动编码和终端编码查询方案活动申请
     *
     * @param activityCode
     * @param terminalCode
     * @return
     */
    SfaActSchemePosApplyRespVo queryExecutionDetailByActivityCodeAndTerminalCode(String activityCode, String terminalCode);

    /**
     * 活动参与情况
     *
     * @param sfaActSchemePosApplyReqVo
     * @return
     */
    PageResult<SfaActSchemeTerminalRespVo> parList(SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo);
}

