package com.biz.crm.actscheme.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.actscheme.mapper.SfaActSchemePosApplyMapper;
import com.biz.crm.actscheme.model.SfaActSchemeEntity;
import com.biz.crm.actscheme.model.SfaActSchemePosApplyEntity;
import com.biz.crm.actscheme.service.ISfaActSchemePosApplyService;
import com.biz.crm.actscheme.service.ISfaActSchemeService;
import com.biz.crm.asexecution.mapper.SfaAsStopMapper;
import com.biz.crm.asexecution.model.SfaAsCashingEntity;
import com.biz.crm.asexecution.model.SfaAsExecutionEntity;
import com.biz.crm.asexecution.model.SfaAsStopEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.service.ISfaAsCashingService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.asexecution.service.ISfaAsStopService;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.act.TaProcessBizRelationEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalCurrentAndSubVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemePosApplyReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeTerminalRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsStopRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.util.*;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动执行;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaActSchemePosApplyServiceExpandImpl")
@Transactional
public class SfaActSchemePosApplyServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaActSchemePosApplyMapper, SfaActSchemePosApplyEntity> implements ISfaActSchemePosApplyService {

    @Resource
    private SfaActSchemePosApplyMapper sfaActSchemePosApplyMapper;
    @Autowired
    private ISfaActSchemeService sfaActSchemeService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private ISfaAsStopService sfaAsStopService;

    @Resource
    private SfaAsStopMapper sfaAsStopMapper;

    @Autowired
    private TaActBaseFeign activityFeign;
    @Autowired
    private ISfaAsExecutionService sfaAsExecutionService;
    @Autowired
    private ISfaAsCashingService sfaAsCashingService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaActSchemePosApplyRespVo> findList(SfaActSchemePosApplyReqVo reqVo) {
        Page<SfaActSchemePosApplyRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActSchemePosApplyRespVo> list = sfaActSchemePosApplyMapper.findList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Map<String, String> displayMap = DictUtil.dictMap(DictConstant.DISPLAY_TYPE);
            Map<String, String> terminalMap = DictUtil.dictMap(DictConstant.TERMINAL_TYPE);
            List<String> activityCodeList = new ArrayList<>();
            for (SfaActSchemePosApplyRespVo actSchemePosApplyRespVo : list) {
                activityCodeList.add(actSchemePosApplyRespVo.getActivityCode());
            }
            Map<String, List<SfaAsStopRespVo>> asStopMap = new HashMap<>();
            List<SfaAsStopEntity> asStopEntityList = sfaAsStopService.lambdaQuery()
                    .in(SfaAsStopEntity::getActivityCode, activityCodeList).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asStopEntityList)) {
                List<SfaAsStopRespVo> asStopRespVoList = CrmBeanUtil.copyList(asStopEntityList, SfaAsStopRespVo.class);
                asStopMap = asStopRespVoList.stream().collect(Collectors.groupingBy(SfaAsStopRespVo::getActivityCode));
            }
            for (SfaActSchemePosApplyRespVo actSchemePosApplyRespVo : list) {
                int actualTermNum = 0;
                if (asStopMap.containsKey(actSchemePosApplyRespVo.getActivityCode())) {
                    List<SfaAsStopRespVo> sfaAsStopRespVos = asStopMap.get(actSchemePosApplyRespVo.getActivityCode());
                    if (CollectionUtil.listNotEmptyNotSizeZero(sfaAsStopRespVos)) {
                        actualTermNum = sfaAsStopRespVos.size();
                    }
                }
                actSchemePosApplyRespVo.setActualTermNum(String.valueOf(actualTermNum));
                if (StringUtils.isNotEmpty(actSchemePosApplyRespVo.getDisplayType())) {
                    List<String> displayTypeList = Arrays.asList(actSchemePosApplyRespVo.getDisplayType().split(","));
                    actSchemePosApplyRespVo.setDisplayTypeList(displayTypeList);
                    List<String> displayTypeDescList = new ArrayList<>();
                    for (String displayType : displayTypeList) {
                        if (displayMap.containsKey(displayType)) {
                            displayTypeDescList.add(displayMap.get(displayType));
                        } else {
                            displayTypeDescList.add(displayType);
                        }
                    }
                    String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
                    actSchemePosApplyRespVo.setDisplayTypeDesc(displayTypeDesc);
                    actSchemePosApplyRespVo.setDisplayTypeDescList(displayTypeDescList);
                }
                if (StringUtils.isNotEmpty(actSchemePosApplyRespVo.getTerminalType())) {
                    List<String> terminalTypeList = Arrays.asList(actSchemePosApplyRespVo.getTerminalType().split(","));
                    actSchemePosApplyRespVo.setTerminalTypeList(terminalTypeList);
                    List<String> terminalTypeDescList = new ArrayList<>();
                    for (String terminalType : terminalTypeList) {
                        if (terminalMap.containsKey(terminalType)) {
                            terminalTypeDescList.add(terminalMap.get(terminalType));
                        } else {
                            terminalTypeDescList.add(terminalType);
                        }
                    }
                    String terminalTypeDesc = Joiner.on(",").join(terminalTypeDescList);
                    actSchemePosApplyRespVo.setTerminalTypeDesc(terminalTypeDesc);
                    actSchemePosApplyRespVo.setTerminalTypeDescList(terminalTypeDescList);
                }
                if (StringUtils.isNotEmpty(actSchemePosApplyRespVo.getPaymentMethod())) {
                    String paymentMethodDesc = actSchemePosApplyRespVo.getPaymentMethod();
                    if (SfaActivityEnum.paymentMethod.GETMAP.containsKey(actSchemePosApplyRespVo.getPaymentMethod())) {
                        paymentMethodDesc = SfaActivityEnum.paymentMethod.GETMAP.get(actSchemePosApplyRespVo.getPaymentMethod());
                    }
                    actSchemePosApplyRespVo.setPaymentMethodDesc(paymentMethodDesc);
                }
            }
        }
        return PageResult.<SfaActSchemePosApplyRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 通过id查询详情
     *
     * @param id
     * @return
     */
    @Override
    @CrmDictMethod
    public SfaActSchemePosApplyRespVo queryDetailById(String id) {
        AssertUtils.isNotEmpty(id, "数据主键id不能为空");
        SfaActSchemePosApplyEntity sfaActSchemePosApplyEntity = this.lambdaQuery().eq(SfaActSchemePosApplyEntity::getId, id).one();
        if (sfaActSchemePosApplyEntity == null) {
            throw new BusinessException("未查询到方案活动明细");
        }
        SfaActSchemeRespVo sfaActSchemeRespVo = new SfaActSchemeRespVo();
        SfaActSchemePosApplyRespVo respVo = CrmBeanUtil.copy(sfaActSchemePosApplyEntity, SfaActSchemePosApplyRespVo.class);
        Map<String, String> displayMap = DictUtil.dictMap(DictConstant.DISPLAY_TYPE);
        Map<String, String> terminalMap = DictUtil.dictMap(DictConstant.TERMINAL_TYPE);
        if (StringUtils.isNotEmpty(respVo.getDisplayType())) {
            List<String> displayTypeList = Arrays.asList(respVo.getDisplayType().split(","));
            respVo.setDisplayTypeList(displayTypeList);
            List<String> displayTypeDescList = new ArrayList<>();
            for (String displayType : displayTypeList) {
                if (displayMap.containsKey(displayType)) {
                    displayTypeDescList.add(displayMap.get(displayType));
                } else {
                    displayTypeDescList.add(displayType);
                }
            }
            String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
            respVo.setDisplayTypeDesc(displayTypeDesc);
            respVo.setDisplayTypeDescList(displayTypeDescList);
        }
        if (StringUtils.isNotEmpty(respVo.getTerminalType())) {
            List<String> terminalTypeList = Arrays.asList(respVo.getTerminalType().split(","));
            respVo.setTerminalTypeList(terminalTypeList);
            List<String> terminalTypeDescList = new ArrayList<>();
            for (String terminalType : terminalTypeList) {
                if (terminalMap.containsKey(terminalType)) {
                    terminalTypeDescList.add(terminalMap.get(terminalType));
                } else {
                    terminalTypeDescList.add(terminalType);
                }
            }
            String terminalTypeDesc = Joiner.on(",").join(terminalTypeDescList);
            respVo.setTerminalTypeDesc(terminalTypeDesc);
            respVo.setTerminalTypeDescList(terminalTypeDescList);
        }
        if (StringUtils.isNotEmpty(respVo.getPaymentMethod())) {
            String paymentMethodDesc = respVo.getPaymentMethod();
            if (SfaActivityEnum.paymentMethod.GETMAP.containsKey(respVo.getPaymentMethod())) {
                paymentMethodDesc = SfaActivityEnum.paymentMethod.GETMAP.get(respVo.getPaymentMethod());
            }
            respVo.setPaymentMethodDesc(paymentMethodDesc);
        }

        if (StringUtils.isNotEmpty(respVo.getSchemeCode())) {
            SfaActSchemeEntity sfaActSchemeEntity = sfaActSchemeService.lambdaQuery().eq(SfaActSchemeEntity::getSchemeCode, respVo.getSchemeCode()).one();
            if (sfaActSchemeEntity == null) {
                throw new BusinessException("未查询到活动方案明细");
            }
            sfaActSchemeRespVo = sfaActSchemeService.queryDetailById(sfaActSchemeEntity.getId());
            respVo.setDescribe(sfaActSchemeRespVo.getSchemeDesc());
            respVo.setActSchemeSetmealList(sfaActSchemeRespVo.getActSchemeSetmealList());
        }
        respVo.setSfaActSchemeRespVo(sfaActSchemeRespVo);
        respVo.setParticipateInTypeMap(SfaActivityEnum.participateInType.GETMAP);
        respVo.setPaymentMethodMap(SfaActivityEnum.paymentMethod.GETMAP);
        //参与列表
        SfaActSchemePosApplyReqVo reqVo = new SfaActSchemePosApplyReqVo();
        reqVo.setActivityCode(respVo.getActivityCode());
        List<SfaAsStopRespVo> asStopRespVoList = findAsStopList(reqVo);
        respVo.setAsStopList(asStopRespVoList);
        return respVo;
    }

    /**
     * 活动对应参与列表
     *
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public List<SfaAsStopRespVo> findAsStopList(SfaActSchemePosApplyReqVo reqVo) {
        List<SfaAsStopRespVo> asStopRespVoList = new ArrayList<>();
        if (StringUtils.isEmpty(reqVo.getActivityCode())) {
            return asStopRespVoList;
        }
        List<SfaAsStopEntity> asStopEntityList = new ArrayList<>();
        if (StringUtils.isNotEmpty(reqVo.getTerminalCode())) {
            asStopEntityList = sfaAsStopService.lambdaQuery()
                    .eq(SfaAsStopEntity::getActivityCode, reqVo.getActivityCode())
                    .eq(SfaAsStopEntity::getTerminalCode, reqVo.getTerminalCode()).list();
        } else {
            asStopEntityList = sfaAsStopService.lambdaQuery()
                    .eq(SfaAsStopEntity::getActivityCode, reqVo.getActivityCode()).list();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(asStopEntityList)) {
            //查询执行记录
            Map<String, List<SfaAsExecutionEntity>> asExecutionMap = new HashMap<>();
            List<SfaAsExecutionEntity> asExecutionEntities = new ArrayList<>();
            if (StringUtils.isNotEmpty(reqVo.getTerminalCode())) {
                asExecutionEntities = sfaAsExecutionService.lambdaQuery()
                        .eq(SfaAsExecutionEntity::getActivityCode, reqVo.getActivityCode())
                        .eq(SfaAsExecutionEntity::getTerminalCode, reqVo.getTerminalCode()).list();
            } else {
                asExecutionEntities = sfaAsExecutionService.lambdaQuery()
                        .eq(SfaAsExecutionEntity::getActivityCode, reqVo.getActivityCode()).list();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(asExecutionEntities)) {
                asExecutionMap = asExecutionEntities.stream().collect(Collectors.groupingBy(SfaAsExecutionEntity::getTerminalCode));
            }
            //查询兑付
            Map<String, List<SfaAsCashingEntity>> asCashingMap = new HashMap<>();
            List<SfaAsCashingEntity> asCashingEntityList = new ArrayList<>();
            if (StringUtils.isNotEmpty(reqVo.getTerminalCode())) {
                asCashingEntityList = sfaAsCashingService.lambdaQuery()
                        .eq(SfaAsCashingEntity::getActivityCode, reqVo.getActivityCode())
                        .eq(SfaAsCashingEntity::getTerminalCode, reqVo.getTerminalCode()).list();
            } else {
                asCashingEntityList = sfaAsCashingService.lambdaQuery()
                        .eq(SfaAsCashingEntity::getActivityCode, reqVo.getActivityCode()).list();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(asCashingEntityList)) {
                asCashingMap = asCashingEntityList.stream().collect(Collectors.groupingBy(SfaAsCashingEntity::getTerminalCode));
            }
            //查询协议
            Map<String, List<SfaAsTreatyEntity>> asTreatyMap = new HashMap<>();
            List<SfaAsTreatyEntity> asTreatyEntityList = new ArrayList<>();
            if (StringUtils.isNotEmpty(reqVo.getTerminalCode())) {
                asTreatyEntityList = sfaAsTreatyService.lambdaQuery()
                        .eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActivityCode())
                        .eq(SfaAsTreatyEntity::getTerminalCode, reqVo.getTerminalCode()).list();
            } else {
                asTreatyEntityList = sfaAsTreatyService.lambdaQuery()
                        .eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActivityCode()).list();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(asTreatyEntityList)) {
                asTreatyMap = asTreatyEntityList.stream().collect(Collectors.groupingBy(SfaAsTreatyEntity::getTerminalCode));
            }
            asStopRespVoList = CrmBeanUtil.copyList(asStopEntityList, SfaAsStopRespVo.class);
            for (SfaAsStopRespVo asStopRespVo : asStopRespVoList) {
                if (YesNoEnum.yesNoEnum.ONE.getValue().equals(asStopRespVo.getStopState())) {
                    asStopRespVo.setActualSituation("已终止");
                } else if (asCashingMap.containsKey(asStopRespVo.getTerminalCode())) {
                    asStopRespVo.setActualSituation("已兑付");
                } else if (asTreatyMap.containsKey(asStopRespVo.getTerminalCode())) {
                    asStopRespVo.setActualSituation("已签署");
                } else if (asExecutionMap.containsKey(asStopRespVo.getTerminalCode())) {
                    SfaAsExecutionEntity asExecutionEntity = asExecutionMap.get(asStopRespVo.getTerminalCode()).get(0);
                    if (SfaActivityEnum.participateInType.A.getVal().equals(asExecutionEntity.getParticipateInType())) {
                        asStopRespVo.setActualSituation(SfaActivityEnum.participateInType.A.getDesc());
                    } else {
                        asStopRespVo.setActualSituation(SfaActivityEnum.participateInType.F.getDesc());
                    }
                }
            }
        }
        return asStopRespVoList;
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaActivityExecutionRespVo
     */
    @Override
    public SfaActSchemePosApplyRespVo query(SfaActSchemePosApplyReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActSchemePosApplyReqVo reqVo) {
        //参数校验
        this.checkParam(reqVo);
        SfaActSchemePosApplyEntity entity = CrmBeanUtil.copy(reqVo, SfaActSchemePosApplyEntity.class);
        entity.setActivityCode(CodeUtil.getCodeDefault());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(reqVo.getIsSubmit())) {
            //流程提交
            entity.setBpmState(TaProcessBizRelationEnum.bpmStatus.APPROVAL.getValue());
            this.sendToActivity(entity, reqVo);
            this.updateById(entity);
        }
    }

    /**
     * 构建流程并提交
     *
     * @param entity
     * @param reqVo
     */
    private void sendToActivity(SfaActSchemePosApplyEntity entity, SfaActSchemePosApplyReqVo reqVo) {
        //当前登录人
        UserRedis user = UserUtils.getUser();
        Map<String, String> map = DictUtil.getDictValueMapsByCodes("activiti_apply_keys");
        if (map == null) {
            throw new BusinessException("请配置<数据字典>:activiti_apply_keys");
        }
        String processKey = map.get(ActivitiEnum.FormTypeEnum.ACT_SCHEME_POS_APPLY.getProcessKey());
        if (StringUtils.isEmpty(processKey)) {
            throw new BusinessException("请在数据字典-activiti_apply_keys-中添加字典");
        }
        //提交审批
        StartProcessReqVo processReqVo = StartProcessReqVo.builder()
                .businessCode(entity.getActivityCode())
                .callBackFeign(ActivitiEnum.FormTypeEnum.ACT_SCHEME_POS_APPLY.getCallBackFeign())
                .formNo(entity.getId())
                .processKey(processKey)
                .costType(ActivitiEnum.FormTypeEnum.ACT_SCHEME_POS_APPLY.getCostType())
                .formType(ActivitiEnum.FormTypeEnum.ACT_SCHEME_POS_APPLY.getFormType())
                .remark("方案活动申请审批")
                .title(entity.getActivityName())
                .userCode(user.getUsername())
                .posCode(user.getPoscode())
                .signTicket(System.currentTimeMillis() + "")
                .build();
        String processNo = ActivityUtils.startProcess(processReqVo);
        entity.setProcessCode(processNo);
    }


    /**
     * 校验参数信息
     *
     * @param reqVo
     */
    protected void checkParam(SfaActSchemePosApplyReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty(reqVo.getSchemeCode(), "方案编码为空");
        SfaActSchemeEntity sfaActSchemeEntity = sfaActSchemeService.lambdaQuery().eq(SfaActSchemeEntity::getSchemeCode, reqVo.getSchemeCode()).one();
        if (sfaActSchemeEntity == null) {
            throw new BusinessException("未查询到活动方案");
        }
        reqVo.setActivityType(sfaActSchemeEntity.getSchemeType());
        AssertUtils.isNotEmpty(reqVo.getActivityName(), "活动名称为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalTypeList(), "门店类型为空");
        reqVo.setTerminalType(Joiner.on(",").join(reqVo.getTerminalTypeList()));
        AssertUtils.isNotEmpty(reqVo.getOaAuditCode(), "OA核销号为空");
        AssertUtils.isNotEmpty(reqVo.getActCostAmount(), "活动费用为空");
        AssertUtils.isNotEmpty(reqVo.getPlanSalesVolume(), "计划销量为空");
        AssertUtils.isNotEmpty(reqVo.getSingleCost(), "单箱成本为空");
        AssertUtils.isNotEmpty(reqVo.getDisplayTypeList(), "陈列类型为空");
        reqVo.setDisplayType(Joiner.on(",").join(reqVo.getDisplayTypeList()));
        AssertUtils.isNotEmpty(reqVo.getPlanTermNum(), "计划投入门店数量为空");
        AssertUtils.isNotEmpty(reqVo.getPaymentMethod(), "兑付方式为空");
        LocalDate activityStartTime = null;
        LocalDate activityEndTime = null;
        LocalDate now = LocalDate.now();
        try {
            activityStartTime = LocalDate.parse(reqVo.getActivityStartTime());
            activityEndTime = LocalDate.parse(reqVo.getActivityEndTime());
        } catch (Exception e) {
            throw new BusinessException("活动执行时间错误");
        }
        if (!activityStartTime.isBefore(activityEndTime)) {
            throw new BusinessException("活动执行开始时间不能大于活动执行结束时间");
        }
        if (now.isAfter(activityEndTime)) {
            throw new BusinessException("活动执行结束时间不可小于当前时间");
        }
        if (ObjectUtils.isEmpty(reqVo.getIsSubmit()) ||
                (!YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(reqVo.getIsSubmit()) &&
                        !YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(reqVo.getIsSubmit())
                )) {
            reqVo.setIsSubmit(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
        }
        reqVo.setBpmState(TaProcessBizRelationEnum.bpmStatus.COMMIT.getValue());
        reqVo.setEndCaseState(SfaActivityEnum.schemeEndCaseState.NOT.getVal());
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActSchemePosApplyReqVo reqVo) {
        //参数校验
        this.checkParam(reqVo);
        SfaActSchemePosApplyEntity entity = this.getById(reqVo.getId());
        String id = entity.getId();
        entity = CrmBeanUtil.copy(reqVo, SfaActSchemePosApplyEntity.class);
        entity.setId(id);
        this.updateById(entity);
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(reqVo.getIsSubmit())) {
            //流程提交
            entity.setBpmState(TaProcessBizRelationEnum.bpmStatus.APPROVAL.getValue());
            this.sendToActivity(entity, reqVo);
            this.updateById(entity);
        }
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaActSchemePosApplyEntity> sfaActSchemePosApplyEntities = sfaActSchemePosApplyMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemePosApplyEntities)) {
            sfaActSchemePosApplyEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActSchemePosApplyEntities);
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaActSchemePosApplyEntity> sfaActSchemePosApplyEntities = sfaActSchemePosApplyMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemePosApplyEntities)) {
            sfaActSchemePosApplyEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActSchemePosApplyEntities);
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaActSchemePosApplyEntity> sfaActSchemePosApplyEntities = sfaActSchemePosApplyMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemePosApplyEntities)) {
            sfaActSchemePosApplyEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActSchemePosApplyEntities);
    }

    /**
     * 结案
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void endCase(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaActSchemePosApplyEntity> sfaActSchemePosApplyEntities = sfaActSchemePosApplyMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemePosApplyEntities)) {
            sfaActSchemePosApplyEntities.forEach(o -> {
                if (TaProcessBizRelationEnum.bpmStatus.APPROVAL.getValue().equals(o.getBpmState())) {
                    throw new BusinessException("活动【" + o.getActivityCode() + "】,在审批中不能结案");
                }
                if(o.getEndCaseState().equals(SfaActivityEnum.schemeEndCaseState.CLOSE.getVal())){
                    throw new BusinessException("活动【" + o.getActivityCode() + "】已关闭，不能结案");
                }
                o.setEndCaseState(SfaActivityEnum.schemeEndCaseState.TOO.getVal());

                //查询所有协议参与是否对付
                List<SfaAsTreatyEntity> treatyEntities = sfaAsTreatyService.lambdaQuery()
                        .eq(SfaAsTreatyEntity::getActivityCode, o.getActivityCode()).list();
                for (SfaAsTreatyEntity treatyEntity : treatyEntities) {
                    if(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal().equals(treatyEntity.getTreatyStatus())){
                        throw new BusinessException("活动【" + o.getActivityCode() + " | " + o.getActivityName() + "】存在执行中的协议，不能结案！");
                    }
                }
                if(org.springframework.util.CollectionUtils.isEmpty(treatyEntities)){
                    throw new BusinessException("活动【" + o.getActivityCode() + " | " + o.getActivityName() + "】未签署协议，不能结案！");
                }
            });
        }
        this.updateBatchById(sfaActSchemePosApplyEntities);
    }

    /**
     * 关闭
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void close(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaActSchemePosApplyEntity> sfaActSchemePosApplyEntities = sfaActSchemePosApplyMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemePosApplyEntities)) {
            sfaActSchemePosApplyEntities.forEach(o -> {
                if (TaProcessBizRelationEnum.bpmStatus.APPROVAL.getValue().equals(o.getBpmState())) {
                    throw new BusinessException("活动【" + o.getActivityCode() + "】,在审批中不能关闭");
                }
                if(o.getEndCaseState().equals(SfaActivityEnum.schemeEndCaseState.TOO.getVal())){
                    throw new BusinessException("活动【" + o.getActivityCode() + "】已结案，不能关闭");
                }
                o.setEndCaseState(SfaActivityEnum.schemeEndCaseState.CLOSE.getVal());

                //存在签署协议且未终止的数据不能关闭
                String activityCode = o.getActivityCode();
                List<SfaAsTreatyEntity> asTreatyEntities = sfaAsTreatyService.lambdaQuery()
                        .eq(SfaAsTreatyEntity::getActivityCode, activityCode).list();
                //门店编码集合
                List<String> terminalCodes = asTreatyEntities.stream().map(SfaAsTreatyEntity::getTerminalCode).collect(Collectors.toList());
                if(CollectionUtil.listNotEmptyNotSizeZero(terminalCodes)) {
                    List<SfaAsStopEntity> treatyEntities = sfaAsStopService.lambdaQuery()
                            .eq(SfaAsStopEntity::getActivityCode, activityCode)
                            .eq(SfaAsStopEntity::getStopState, YesNoEnum.yesNoEnum.ZERO.getValue())
                            .in(SfaAsStopEntity::getTerminalCode,terminalCodes)
                            .list();
                    if (CollectionUtil.listNotEmptyNotSizeZero(treatyEntities)) {
                        throw new BusinessException("活动【" + o.getActivityCode() + " | " + o.getActivityName() + "】已有门店签署协议且未终止，不能关闭！");
                    }
                }
            });
        }
        this.updateBatchById(sfaActSchemePosApplyEntities);
    }


    /**
     * 查询方案活动执行列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActivityExecutionRespVo> findActSchemeList(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "网点编码为空");
        AssertUtils.isNotEmpty(reqVo.getClientType(), "网点类型为空");
        String poscode = UserUtils.getUser().getPoscode();
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        String terminalType = null;
        //判断是经销商
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(reqVo.getClientType())) {
            return PageResult.<SfaActivityExecutionRespVo>builder()
                    .data(new ArrayList<>())
                    .count(Long.valueOf(0))
                    .build();
        } else {
            MdmTerminalVo mdmTerminalVo = getMdmTerminalVo(reqVo.getClientCode());
            terminalType = mdmTerminalVo.getTerminalType();
            if (StringUtils.isEmpty(terminalType)) {
                return PageResult.<SfaActivityExecutionRespVo>builder()
                        .data(new ArrayList<>())
                        .count(Long.valueOf(0))
                        .build();
            }
        }
        reqVo.setTerminalType(terminalType);
        List<String> posCodeList = new ArrayList<>();
        posCodeList.add(poscode);
        List<MdmPositionRespVo> mdmPositionRespVoList = PositionUtil.getParentPositionListIncludeSelf(poscode);
        if (CollectionUtil.listNotEmptyNotSizeZero(mdmPositionRespVoList)) {
            for (MdmPositionRespVo mdmPositionRespVo : mdmPositionRespVoList) {
                posCodeList.add(mdmPositionRespVo.getPositionCode());
            }
        }

        reqVo.setPosCodeList(posCodeList);
        reqVo.setNow(now);
        reqVo.setBpmState(TaProcessBizRelationEnum.bpmStatus.PASS.getValue());
        reqVo.setEndCaseState(SfaActivityEnum.schemeEndCaseState.NOT.getVal());
        Page<SfaActivityExecutionRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActivityExecutionRespVo> list = sfaActSchemePosApplyMapper.findActSchemeList(page, reqVo);
        for (SfaActivityExecutionRespVo respVo : list) {
            respVo.setActivityType(reqVo.getActivityType());
        }
        return PageResult.<SfaActivityExecutionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();

    }

    /**
     * 查询方案活动执行完成列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepActivityExecutionRespVo> findActSchemeCompleteList(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "网点编码为空");
        AssertUtils.isNotEmpty(reqVo.getClientType(), "网点类型为空");
        String poscode = UserUtils.getUser().getPoscode();
        String terminalType = null;
        //判断是经销商
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(reqVo.getClientType())) {
            return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                    .data(new ArrayList<>())
                    .count(Long.valueOf(0))
                    .build();
        } else {
            MdmTerminalVo mdmTerminalVo = getMdmTerminalVo(reqVo.getClientCode());
            terminalType = mdmTerminalVo.getTerminalType();
            if (StringUtils.isEmpty(terminalType)) {
                return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                        .data(new ArrayList<>())
                        .count(Long.valueOf(0))
                        .build();
            }
        }
        reqVo.setTerminalType(terminalType);
        List<String> posCodeList = new ArrayList<>();
        posCodeList.add(poscode);
        List<MdmPositionRespVo> mdmPositionRespVoList = PositionUtil.getParentPositionListIncludeSelf(poscode);
        if (CollectionUtil.listNotEmptyNotSizeZero(mdmPositionRespVoList)) {
            for (MdmPositionRespVo mdmPositionRespVo : mdmPositionRespVoList) {
                posCodeList.add(mdmPositionRespVo.getPositionCode());
            }
        }
        reqVo.setPosCodeList(posCodeList);
        reqVo.setBpmState(TaProcessBizRelationEnum.bpmStatus.PASS.getValue());
        reqVo.setEndCaseState(SfaActivityEnum.schemeEndCaseState.TOO.getVal());
        Page<SfaVisitStepActivityExecutionRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepActivityExecutionRespVo> list = sfaActSchemePosApplyMapper.findActSchemeCompleteList(page, reqVo);
        for (SfaVisitStepActivityExecutionRespVo respVo : list) {
            respVo.setActivityType(reqVo.getActivityType());
        }
        return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();


    }

    /**
     * 获取终端类型
     */
    private MdmTerminalVo getMdmTerminalVo(String clientCode) {
        MdmTerminalVo mdmTerminalVo = null;
        Result<MdmTerminalVo> mdmTerminalVoResult = mdmTerminalFeign.query(null, clientCode);
        if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null) {
            mdmTerminalVo = mdmTerminalVoResult.getResult();
        }
        return mdmTerminalVo;
    }

    /**
     * 工作流审批回调
     *
     * @param activitiCallBackVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void callback(ActivitiCallBackVo activitiCallBackVo) {
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = sfaActSchemePosApplyMapper.selectById(activitiCallBackVo.getFormNo());
        if (!ObjectUtils.isEmpty(actSchemePosApplyEntity)) {
            //审批通过
            if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState()) {
                actSchemePosApplyEntity.setBpmState(TaProcessBizRelationEnum.bpmStatus.PASS.getValue());
            }
            //审批驳回
            if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState()) {
                actSchemePosApplyEntity.setBpmState(TaProcessBizRelationEnum.bpmStatus.REJECT.getValue());
            }
            //审批追回
            if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState()) {
                actSchemePosApplyEntity.setBpmState(TaProcessBizRelationEnum.bpmStatus.BACK.getValue());
            }
        }
        sfaActSchemePosApplyMapper.updateById(actSchemePosApplyEntity);
    }

    /**
     * 通过活动编码和终端编码查询方案活动申请
     *
     * @param activityCode
     * @param terminalCode
     * @return
     */
    @Override
    public SfaActSchemePosApplyRespVo queryExecutionDetailByActivityCodeAndTerminalCode(String activityCode, String terminalCode) {
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = this
                .lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, activityCode).one();
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("未查询到对应活动[" + activityCode + "]");
        }
        SfaActSchemeRespVo sfaActSchemeRespVo = new SfaActSchemeRespVo();
        SfaActSchemePosApplyRespVo respVo = CrmBeanUtil.copy(actSchemePosApplyEntity, SfaActSchemePosApplyRespVo.class);
        Map<String, String> displayMap = DictUtil.dictMap(DictConstant.DISPLAY_TYPE);
        Map<String, String> terminalMap = DictUtil.dictMap(DictConstant.TERMINAL_TYPE);
        //陈列类型
        Map<String, String> displayTypeMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(respVo.getDisplayType())) {
            List<String> displayTypeList = Arrays.asList(respVo.getDisplayType().split(","));
            respVo.setDisplayTypeList(displayTypeList);
            List<String> displayTypeDescList = new ArrayList<>();
            for (String displayType : displayTypeList) {
                if (displayMap.containsKey(displayType)) {
                    displayTypeDescList.add(displayMap.get(displayType));
                } else {
                    displayTypeDescList.add(displayType);
                }
                displayTypeMap.put(displayType, displayMap.get(displayType));
            }
            String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
            respVo.setDisplayTypeDesc(displayTypeDesc);
            respVo.setDisplayTypeDescList(displayTypeDescList);
            respVo.setDisplayTypeMap(displayTypeMap);
        }
        //门店类型
        Map<String, String> terminalTypeMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(respVo.getTerminalType())) {
            List<String> terminalTypeList = Arrays.asList(respVo.getTerminalType().split(","));
            respVo.setTerminalTypeList(terminalTypeList);
            List<String> terminalTypeDescList = new ArrayList<>();
            for (String terminalType : terminalTypeList) {
                if (terminalMap.containsKey(terminalType)) {
                    terminalTypeDescList.add(terminalMap.get(terminalType));
                } else {
                    terminalTypeDescList.add(terminalType);
                }
                terminalTypeMap.put(terminalType, terminalMap.get(terminalType));
            }
            String terminalTypeDesc = Joiner.on(",").join(terminalTypeDescList);
            respVo.setTerminalTypeDesc(terminalTypeDesc);
            respVo.setTerminalTypeDescList(terminalTypeDescList);
            respVo.setTerminalTypeMap(terminalTypeMap);
        }
        if (StringUtils.isNotEmpty(respVo.getPaymentMethod())) {
            String paymentMethodDesc = respVo.getPaymentMethod();
            if (SfaActivityEnum.paymentMethod.GETMAP.containsKey(respVo.getPaymentMethod())) {
                paymentMethodDesc = SfaActivityEnum.paymentMethod.GETMAP.get(respVo.getPaymentMethod());
            }
            respVo.setPaymentMethodDesc(paymentMethodDesc);
        }

        if (StringUtils.isNotEmpty(respVo.getSchemeCode())) {
            SfaActSchemeEntity sfaActSchemeEntity = sfaActSchemeService.lambdaQuery().eq(SfaActSchemeEntity::getSchemeCode, respVo.getSchemeCode()).one();
            if (sfaActSchemeEntity == null) {
                throw new BusinessException("未查询到活动方案明细");
            }
            sfaActSchemeRespVo = sfaActSchemeService.queryMobileDetailById(sfaActSchemeEntity.getId());
            respVo.setDescribe(sfaActSchemeRespVo.getSchemeDesc());
            //respVo.setActSchemeSetmealList(sfaActSchemeRespVo.getActSchemeSetmealList());
        }
        respVo.setSfaActSchemeRespVo(sfaActSchemeRespVo);
        respVo.setParticipateInTypeMap(SfaActivityEnum.participateInType.GETMAP);
        respVo.setPaymentMethodMap(SfaActivityEnum.paymentMethod.GETMAP);
        return respVo;
    }

    /**
     * 活动参与情况
     *
     * @param params
     * @return
     */
    @Override
    public PageResult<SfaActSchemeTerminalRespVo> parList(SfaActSchemePosApplyReqVo params) {
        //数据集合
        List<SfaActSchemeTerminalRespVo> sfaActSchemeTerminalRespVos = Lists.newArrayList();
        AssertUtils.isNotEmpty(params.getId(), "活动ID不能为空!");

        List<String> codes = Lists.newArrayList();
        codes.add("-1");
        SfaActSchemePosApplyEntity entity = sfaActSchemePosApplyMapper.selectById(params.getId());
        String activityCode = entity.getActivityCode();
        //已关闭
        Map<String, String> stopEntityMap = new HashMap<>();
        //已签署协议
        Map<String, String> treatyEntityMap = new HashMap<>();
        //已兑换
        Map<String, String> cashingEntityMap = new HashMap<>();
        //免费参与
        Map<String, String> parFreeMap = new HashMap<>();
        if (!StringUtils.isEmpty(params.getParType())&&SfaActivityEnum.ParType.GETMAP.containsKey(params.getParType())) {
            SfaActivityEnum.ParType parType = SfaActivityEnum.ParType.getByCode(params.getParType());
            switch (parType) {
                case YGB:
                    List<String> stopTerminalCodes = sfaAsStopService.lambdaQuery().eq(SfaAsStopEntity::getActivityCode, activityCode)
                            .eq(SfaAsStopEntity::getStopState, YesNoEnum.yesNoEnum.ONE.getValue()).list()
                            .stream().map(SfaAsStopEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(stopTerminalCodes)){
                        stopEntityMap =  stopTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
                    }
                    break;
                case YDF:
                    List<String> ydfCodes = Lists.newArrayList();
                    List<String> ydfStopTerminalCodes = sfaAsStopService.lambdaQuery().eq(SfaAsStopEntity::getActivityCode, activityCode)
                            .eq(SfaAsStopEntity::getStopState, YesNoEnum.yesNoEnum.ONE.getValue()).list()
                            .stream().map(SfaAsStopEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(ydfStopTerminalCodes)){
                        ydfCodes.addAll(ydfStopTerminalCodes);
                    }

                    List<String> cashingTerminalCodes = sfaAsCashingService.lambdaQuery()
                            .eq(SfaAsCashingEntity::getActivityCode, activityCode)
                            .notIn(SfaAsCashingEntity::getTerminalCode, CollectionUtil.listNotEmptyNotSizeZero(ydfCodes)?ydfCodes:codes).list()
                            .stream().map(SfaAsCashingEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(cashingTerminalCodes)){
                        cashingEntityMap =  cashingTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
                    }
                    break;
                case YQS:
                    List<String> yqsCodes = Lists.newArrayList();
                    List<String> yqsStopTerminalCodes = sfaAsStopService.lambdaQuery().eq(SfaAsStopEntity::getActivityCode, activityCode)
                            .eq(SfaAsStopEntity::getStopState, YesNoEnum.yesNoEnum.ONE.getValue()).list()
                            .stream().map(SfaAsStopEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(yqsStopTerminalCodes)){
                        yqsCodes.addAll(yqsStopTerminalCodes);
                    }
                    List<String> yqsCashingTerminalCodes = sfaAsCashingService.lambdaQuery()
                            .eq(SfaAsCashingEntity::getActivityCode, activityCode)
                            .notIn(SfaAsCashingEntity::getTerminalCode, CollectionUtil.listNotEmptyNotSizeZero(yqsCodes)?yqsCodes:codes).list()
                            .stream().map(SfaAsCashingEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(yqsCashingTerminalCodes)){
                        yqsCodes.addAll(yqsCashingTerminalCodes);
                    }
                    List<String> parFreeTerminalCodes = sfaAsTreatyService.lambdaQuery()
                            .eq(SfaAsTreatyEntity::getActivityCode, activityCode)
                            .notIn(SfaAsTreatyEntity::getTerminalCode, CollectionUtil.listNotEmptyNotSizeZero(yqsCodes)?yqsCodes:codes).list()
                            .stream().map(SfaAsTreatyEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(parFreeTerminalCodes)){
                        parFreeMap =  parFreeTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
                    }
                    break;
                case MFCY:
                    List<String> treatyCodes = Lists.newArrayList();
                    List<String> treatyStopTerminalCodes = sfaAsStopService.lambdaQuery().eq(SfaAsStopEntity::getActivityCode, activityCode)
                            .eq(SfaAsStopEntity::getStopState, YesNoEnum.yesNoEnum.ONE.getValue()).list()
                            .stream().map(SfaAsStopEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(treatyStopTerminalCodes)){
                        treatyCodes.addAll(treatyStopTerminalCodes);
                    }
                    List<String> treatyCashingTerminalCodes = sfaAsCashingService.lambdaQuery()
                            .eq(SfaAsCashingEntity::getActivityCode, activityCode)
                            .notIn(SfaAsCashingEntity::getTerminalCode, CollectionUtil.listNotEmptyNotSizeZero(treatyCodes)?treatyCodes:codes).list()
                            .stream().map(SfaAsCashingEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(treatyCashingTerminalCodes)){
                        treatyCodes.addAll(treatyCashingTerminalCodes);
                    }
                    List<String> treatyParFreeTerminalCodes = sfaAsTreatyService.lambdaQuery()
                            .eq(SfaAsTreatyEntity::getActivityCode, activityCode)
                            .notIn(SfaAsTreatyEntity::getTerminalCode, CollectionUtil.listNotEmptyNotSizeZero(treatyCodes)?treatyCodes:codes).list()
                            .stream().map(SfaAsTreatyEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(treatyParFreeTerminalCodes)){
                        treatyCodes.addAll(treatyParFreeTerminalCodes);
                    }
                    List<String> treatyTerminalCodes = sfaAsExecutionService.lambdaQuery()
                            .eq(SfaAsExecutionEntity::getActivityCode, activityCode)
                            .notIn(SfaAsExecutionEntity::getTerminalCode, CollectionUtil.listNotEmptyNotSizeZero(treatyCodes)?treatyCodes:codes)
                            .eq(SfaAsExecutionEntity::getParticipateInType, SfaActivityEnum.participateInType.F.getVal()).list()
                            .stream().map(SfaAsExecutionEntity::getTerminalCode).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(treatyTerminalCodes)){
                        treatyEntityMap =  treatyTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
                    }
                    break;
                default:
            }
        }else if (!StringUtils.isEmpty(params.getParType())&&!SfaActivityEnum.ParType.GETMAP.containsKey(params.getParType())){
            return PageResult.<SfaActSchemeTerminalRespVo>builder()
                    .data(sfaActSchemeTerminalRespVos)
                    .count(0L)
                    .build();
        }else{
//            case YGB:
            List<String> stopTerminalCodes = sfaAsStopService.lambdaQuery()
                    .eq(SfaAsStopEntity::getActivityCode, activityCode)
                    .eq(SfaAsStopEntity::getStopState, YesNoEnum.yesNoEnum.ONE.getValue()).list()
                    .stream().map(SfaAsStopEntity::getTerminalCode).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(stopTerminalCodes)){
                stopEntityMap =  stopTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
//                terminalCodes.addAll(stopTerminalCodes);
            }
//            case YDF:
            List<String> cashingTerminalCodes = sfaAsCashingService.lambdaQuery()
                    .eq(SfaAsCashingEntity::getActivityCode, activityCode).list()
                    .stream().map(SfaAsCashingEntity::getTerminalCode).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(cashingTerminalCodes)){
                cashingEntityMap =  cashingTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
//                terminalCodes.addAll(cashingTerminalCodes);
            }
//            case YQS:
            List<String> treatyTerminalCodes = sfaAsTreatyService.lambdaQuery()
                    .eq(SfaAsTreatyEntity::getActivityCode, activityCode).list()
                    .stream().map(SfaAsTreatyEntity::getTerminalCode).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(treatyTerminalCodes)){
                treatyEntityMap = treatyTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
//                terminalCodes.addAll(treatyTerminalCodes);
            }
//            case MFCY:
            List<String> parFreeTerminalCodes = sfaAsExecutionService.lambdaQuery()
                    .eq(SfaAsExecutionEntity::getActivityCode, activityCode)
                    .eq(SfaAsExecutionEntity::getParticipateInType, SfaActivityEnum.participateInType.F.getVal()).list()
                    .stream().map(SfaAsExecutionEntity::getTerminalCode).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(parFreeTerminalCodes)){
                parFreeMap =  parFreeTerminalCodes.stream().collect(Collectors.toMap(Function.identity(), Function.identity(),(oldDate,newDate)->newDate));
//                terminalCodes.addAll(parFreeTerminalCodes);
            }
        }

        MdmTerminalCurrentAndSubVo currentAndSubVo = new MdmTerminalCurrentAndSubVo();
        //终端编码集合
        Set<String> terminalCodes = Sets.newHashSet();
        terminalCodes.addAll(stopEntityMap.values());
        terminalCodes.addAll(cashingEntityMap.values());
        terminalCodes.addAll(treatyEntityMap.values());
        terminalCodes.addAll(parFreeMap.values());
        if (terminalCodes.size() > 0) {
            currentAndSubVo.setTerminalCodeList(Lists.newArrayList(terminalCodes));
        }else{
            return PageResult.<SfaActSchemeTerminalRespVo>builder()
                    .data(sfaActSchemeTerminalRespVos)
                    .count(0L)
                    .build();
        }
        currentAndSubVo.setPageSize(params.getPageSize());
        currentAndSubVo.setPageNum(params.getPageNum());
        PageResult<MdmTerminalContactPageVo> pageResult = ApiResultUtil.objResult(mdmTerminalFeign.findTerminalAndContactList(currentAndSubVo));
        if (!ObjectUtils.isEmpty(pageResult)) {
            List<MdmTerminalContactPageVo> data = pageResult.getData();
            if (CollectionUtil.listNotEmpty(data)) {
                sfaActSchemeTerminalRespVos = CrmBeanUtil.copyList(data, SfaActSchemeTerminalRespVo.class);
                if (StringUtils.isEmpty(params.getParType())) {
                    for (SfaActSchemeTerminalRespVo o:sfaActSchemeTerminalRespVos){
                        String terminalCode = o.getTerminalCode();
                        if (!ObjectUtils.isEmpty(stopEntityMap.get(terminalCode))) {
                            o.setParDesc(SfaActivityEnum.ParType.YGB.getDesc());
                        }else if (!ObjectUtils.isEmpty(cashingEntityMap.get(terminalCode))) {
                            o.setParDesc(SfaActivityEnum.ParType.YDF.getDesc());
                        } else if (!ObjectUtils.isEmpty(treatyEntityMap.get(terminalCode))) {
                            o.setParDesc(SfaActivityEnum.ParType.YQS.getDesc());
                        } else if (!ObjectUtils.isEmpty(parFreeMap.get(terminalCode))) {
                            o.setParDesc(SfaActivityEnum.ParType.MFCY.getDesc());
                        }
                    }
                }else{
                    sfaActSchemeTerminalRespVos.forEach(o -> {
                        o.setParDesc(SfaActivityEnum.ParType.getByCode(params.getParType()).getDesc());
                    });
                }
            }
            return PageResult.<SfaActSchemeTerminalRespVo>builder()
                    .data(sfaActSchemeTerminalRespVos)
                    .count(pageResult.getCount())
                    .build();
        } else {
            return PageResult.<SfaActSchemeTerminalRespVo>builder()
                    .data(sfaActSchemeTerminalRespVos)
                    .count(0L)
                    .build();
        }
    }
}
