package com.biz.crm.acttask.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.acttask.service.ISfaActProductService;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActProductRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动任务管理-陈列要求 
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@RestController
@RequestMapping("/sfaactproduct")
@Api(tags = "活动任务管理-陈列要求 ")
public class SfaActProductController {
    @Autowired
    private ISfaActProductService sfaActProductService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaActProductRespVo>> list(@RequestBody SfaActProductReqVo sfaActProductReqVo) {
        PageResult<SfaActProductRespVo> result=sfaActProductService.findList(sfaActProductReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaActProductRespVo> query(@RequestBody SfaActProductReqVo sfaActProductReqVo) {
        SfaActProductRespVo respVo=sfaActProductService.query(sfaActProductReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaActProductReqVo sfaActProductReqVo) {
        sfaActProductService.save(sfaActProductReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaActProductReqVo sfaActProductReqVo) {
        sfaActProductService.update(sfaActProductReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaActProductReqVo sfaActProductReqVo) {
        sfaActProductService.deleteBatch(sfaActProductReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaActProductReqVo sfaActProductReqVo) {
        sfaActProductService.enableBatch(sfaActProductReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaActProductReqVo sfaActProductReqVo) {
        sfaActProductService.disableBatch(sfaActProductReqVo);
        return Result.ok("禁用成功");
    }
}
