package com.biz.crm.acttask.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动任务管理-陈列要求 实体类
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_product")
@CrmTable(name = "sfa_act_product", tableNote = "活动任务管理-陈列要求")
public class SfaActProductEntity extends CrmExtTenEntity<SfaActProductEntity> {

    /**
     * 活动编码 活动编码
     */
    @CrmColumn(name = "act_code", length = 32, note = "活动编码 活动编码")
    private String actCode;

    /**
     * 产品层级编码 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32, note = "产品层级编码 产品层级编码")
    private String productLevelCode;

    /**
     * 产品层级名称 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 100, note = "产品层级名称 产品层级名称")
    private String productLevelName;

    /**
     * 产品编码 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码 产品编码")
    private String productCode;

    /**
     * 产品名称 产品名称
     */
    @CrmColumn(name = "product_name", length = 100, note = "产品名称 产品名称")
    private String productName;

    /**
     * 最低陈列面数 最低陈列面数
     */
    @CrmColumn(name = "min_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "最低陈列面数 最低陈列面数")
    private Integer minNumber;

}
