package com.biz.crm.acttask.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动范围 实体类
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_range")
@CrmTable(name = "sfa_act_range", tableNote = "活动范围")
public class SfaActRangeEntity extends CrmExtTenEntity<SfaActRangeEntity> {

    /**
     * 活动编码 活动编码
     */
    @CrmColumn(name = "act_code", length = 32, note = "活动编码")
    private String actCode;

    /**
     * 编码 编码
     */
    @CrmColumn(name = "range_code", length = 32, note = "编码")
    private String rangeCode;

    /**
     * 名称 名称
     */
    @CrmColumn(name = "range_name", length = 32, note = "名称")
    private String rangeName;

    /**
     * 类型 类型(1:渠道;2:组织;3:人员)
     */
    @CrmColumn(name = "sar_type", length = 32, note = "类型")
    private String sarType;

    /**
     * 范围类型 范围类型(1:包含;2:非包含;)
     */
    @CrmColumn(name = "range_type", length = 32, note = "范围类型")
    private String rangeType;

}
