package com.biz.crm.acttask.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 活动任务管理 实体类
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_task")
@CrmTable(name = "sfa_act_task", tableNote = "活动任务管理")
public class SfaActTaskEntity extends CrmExtTenEntity<SfaActTaskEntity> {

    /**
     * 活动编码 活动编码
     */
    @CrmColumn(name = "act_code", length = 32, note = "活动编码")
    private String actCode;

    /**
     * 活动名称 活动名称
     */
    @CrmColumn(name = "act_name", length = 100, note = "活动名称")
    private String actName;

    /**
     * 活动类型 活动类型(display:陈列活动，cost:费用活动)
     */
    @CrmColumn(name = "act_type", length = 32, note = "活动类型")
    private String actType;

    /**
     * 活动状态 活动状态(1待执行;2已完成;3已过期)
     */
    @CrmColumn(name = "act_status", length = 32, note = "活动状态")
    private String actStatus;

    /**
     * 活动开始时间 活动开始时间
     */
    @CrmColumn(name = "begin_date", length = 32, note = "活动开始时间")
    private String beginDate;

    /**
     * 活动结束时间 活动结束时间
     */
    @CrmColumn(name = "end_date", length = 32, note = "活动结束时间")
    private String endDate;

    /**
     * 活动描述 活动描述
     */
    @CrmColumn(name = "act_desc", length = 3000, note = "活动描述")
    private String actDesc;

    /**
     * 预估销售额 费用活动-预估销售额
     */
    @CrmColumn(name = "forecast_sales_amount", mysqlType = "decimal(32,8)", oracleType = "NUMBER(32,8)", note = "预估销售额 费用活动-预估销售额")
    private BigDecimal forecastSalesAmount;

    /**
     * 费用申请金额 费用活动-费用申请金额
     */
    @CrmColumn(name = "apply_amount", mysqlType = "decimal(32,8)", oracleType = "NUMBER(32,8)", note = "费用申请金额 费用活动-费用申请金额")
    private BigDecimal applyAmount;

    /**
     * 活动要求 活动要求
     */
    @CrmColumn(name = "act_require", length = 3000, note = "活动要求")
    private String actRequire;

    /**
     * 任务执行频率 陈列活动-任务执行频率
     */
    @CrmColumn(name = "act_frequency", mysqlType = "decimal(6,2)", oracleType = "NUMBER(6,2)", note = "任务执行频率 陈列活动-任务执行频率")
    private String actFrequency;

}
