package com.biz.crm.acttask.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.acttask.model.SfaActFileEntity;
import com.biz.crm.acttask.mapper.SfaActFileMapper;
import com.biz.crm.acttask.service.ISfaActFileService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActFileRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动附件（示例图片） 接口实现
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActFileServiceExpandImpl")
public class SfaActFileServiceImpl extends ServiceImpl<SfaActFileMapper, SfaActFileEntity> implements ISfaActFileService {

    @Resource
    private SfaActFileMapper sfaActFileMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActFileRespVo> findList(SfaActFileReqVo reqVo){
        Page<SfaActFileRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActFileRespVo> list = sfaActFileMapper.findList(page, reqVo);
        return PageResult.<SfaActFileRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActFileRespVo
     */
    @Override
    public SfaActFileRespVo query(SfaActFileReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActFileReqVo reqVo){
        SfaActFileEntity entity = CrmBeanUtil.copy(reqVo,SfaActFileEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActFileReqVo reqVo){
        SfaActFileEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActFileReqVo reqVo){
        List<SfaActFileEntity> sfaActFileEntities = sfaActFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActFileEntities)){
            sfaActFileEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActFileEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActFileReqVo reqVo){
        //设置状态为启用
        List<SfaActFileEntity> sfaActFileEntities = sfaActFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActFileEntities)){
            sfaActFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActFileEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActFileReqVo reqVo){
        //设置状态为禁用
        List<SfaActFileEntity> sfaActFileEntities = sfaActFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActFileEntities)){
                sfaActFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActFileEntities);
    }
}
