package com.biz.crm.acttask.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.acttask.model.SfaActRangeEntity;
import com.biz.crm.acttask.mapper.SfaActRangeMapper;
import com.biz.crm.acttask.service.ISfaActRangeService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActRangeRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActRangeReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动范围 接口实现
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActRangeServiceExpandImpl")
public class SfaActRangeServiceImpl extends ServiceImpl<SfaActRangeMapper, SfaActRangeEntity> implements ISfaActRangeService {

    @Resource
    private SfaActRangeMapper sfaActRangeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActRangeRespVo> findList(SfaActRangeReqVo reqVo){
        Page<SfaActRangeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActRangeRespVo> list = sfaActRangeMapper.findList(page, reqVo);
        return PageResult.<SfaActRangeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActRangeRespVo
     */
    @Override
    public SfaActRangeRespVo query(SfaActRangeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActRangeReqVo reqVo){
        SfaActRangeEntity entity = CrmBeanUtil.copy(reqVo,SfaActRangeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActRangeReqVo reqVo){
        SfaActRangeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActRangeReqVo reqVo){
        List<SfaActRangeEntity> sfaActRangeEntities = sfaActRangeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActRangeEntities)){
            sfaActRangeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActRangeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActRangeReqVo reqVo){
        //设置状态为启用
        List<SfaActRangeEntity> sfaActRangeEntities = sfaActRangeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActRangeEntities)){
            sfaActRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActRangeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActRangeReqVo reqVo){
        //设置状态为禁用
        List<SfaActRangeEntity> sfaActRangeEntities = sfaActRangeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActRangeEntities)){
                sfaActRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActRangeEntities);
    }
}
