package com.biz.crm.acttask.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acttask.mapper.SfaActFileMapper;
import com.biz.crm.acttask.mapper.SfaActProductMapper;
import com.biz.crm.acttask.mapper.SfaActRangeMapper;
import com.biz.crm.acttask.mapper.SfaActTaskMapper;
import com.biz.crm.acttask.model.SfaActFileEntity;
import com.biz.crm.acttask.model.SfaActProductEntity;
import com.biz.crm.acttask.model.SfaActRangeEntity;
import com.biz.crm.acttask.model.SfaActTaskEntity;
import com.biz.crm.acttask.service.ISfaActFileService;
import com.biz.crm.acttask.service.ISfaActProductService;
import com.biz.crm.acttask.service.ISfaActRangeService;
import com.biz.crm.acttask.service.ISfaActTaskService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaActTaskEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActRangeReqVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActTaskReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActFileRespVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActProductRespVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActRangeRespVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActTaskRespVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.notice.model.SfaNoticeReceivingEntity;
import com.biz.crm.util.*;
import io.swagger.annotations.ApiModelProperty;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 活动任务管理 接口实现
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActTaskServiceExpandImpl")
public class SfaActTaskServiceImpl extends ServiceImpl<SfaActTaskMapper, SfaActTaskEntity> implements ISfaActTaskService {

    @Resource
    private SfaActTaskMapper sfaActTaskMapper;
    @Resource
    private SfaActFileMapper sfaActFileMapper;
    @Resource
    private SfaActProductMapper sfaActProductMapper;
    @Resource
    private SfaActRangeMapper sfaActRangeMapper;

    @Autowired
    private ISfaActProductService iSfaActProductService;
    @Autowired
    private ISfaActRangeService iSfaActRangeService;
    @Autowired
    private ISfaActFileService iSfaActFileService;



    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActTaskRespVo> findList(SfaActTaskReqVo reqVo){
        Page<SfaActTaskRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActTaskRespVo> list = sfaActTaskMapper.findList(page, reqVo);
        return PageResult.<SfaActTaskRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActTaskRespVo
     */
    @Override
    public SfaActTaskRespVo query(SfaActTaskReqVo reqVo){
        List<SfaActTaskRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            return new SfaActTaskRespVo();
        }
        SfaActTaskRespVo sfaActTaskRespVo = list.get(0);
        //查询对应活动范围
        SfaActRangeReqVo rangeReqVo = new SfaActRangeReqVo();
        rangeReqVo.setActCode(sfaActTaskRespVo.getActCode());
        rangeReqVo.setPageSize(-1);
        List<SfaActRangeRespVo> sfaActRangeRespVos = iSfaActRangeService.findList(rangeReqVo).getData();
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaActRangeRespVos)){
            //活动范围包含
            List<SfaActRangeRespVo> sfaActRangeRespContainVos = new ArrayList<>();
            //活动范围不包含
            List<SfaActRangeRespVo> sfaActRangeRespNotContainVos = new ArrayList<>();
            for (SfaActRangeRespVo rangeRespVo:sfaActRangeRespVos){
                if (SfaCommonEnum.rangeTypeEnum.One.getVal().equals(rangeRespVo.getRangeType())){
                    sfaActRangeRespContainVos.add(rangeRespVo);
                }else{
                    sfaActRangeRespNotContainVos.add(rangeRespVo);
                }
            }
            sfaActTaskRespVo.setSfaActRangeRespContainVos(sfaActRangeRespContainVos);
            sfaActTaskRespVo.setSfaActRangeRespNotContainVos(sfaActRangeRespNotContainVos);
        }
        //陈列活动-陈列要求
        SfaActProductReqVo productReqVo = new SfaActProductReqVo();
        productReqVo.setActCode(sfaActTaskRespVo.getActCode());
        productReqVo.setPageSize(-1);
        List<SfaActProductRespVo> sfaActProductRespVos = iSfaActProductService.findList(productReqVo).getData();
        sfaActTaskRespVo.setSfaActProductRespVos(sfaActProductRespVos);
        // 陈列活动-活动附件示例图片
        SfaActFileReqVo fileReqVo = new SfaActFileReqVo();
        fileReqVo.setActCode(sfaActTaskRespVo.getActCode());
        fileReqVo.setPageSize(-1);
        List<SfaActFileRespVo> sfaActFileRespVos = iSfaActFileService.findList(fileReqVo).getData();
        sfaActTaskRespVo.setSfaActFileRespVos(sfaActFileRespVos);
        return sfaActTaskRespVo;
    }

    public void saveCheck(SfaActTaskReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getActName(),"请输入活动名称");
        AssertUtils.isNotEmpty(reqVo.getActType(),"请选择活动类型");
        AssertUtils.isNotEmpty(reqVo.getBeginDate(),"请选择活动开始时间");
        SimpleDateFormat ymd  =new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = null;
        try{
            beginDate = (Date) ymd.parse(reqVo.getBeginDate());
        }catch(Exception e){
            throw new BusinessException("活动开始时间格式错误");
        }
        AssertUtils.isNotEmpty(reqVo.getEndDate(),"请选择活动结束时间");
        Date endDate = null;
        try{
            endDate = (Date) ymd.parse(reqVo.getEndDate());
        }catch(Exception e){
            throw new BusinessException("活动结束时间格式错误");
        }
        if (!(beginDate.getTime() < endDate.getTime())){
            throw new BusinessException("活动开始时间不能大于活动结束时间");
        }

        if (SfaActTaskEnum.actTypeEnum.cost.getVal().equals(reqVo.getActType())){
            String text = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$";
            Pattern pattern=Pattern.compile(text);
            if (null == reqVo.getForecastSalesAmount()){
                throw new BusinessException("请填写预估销售额");
            }
            if (!pattern.matcher(reqVo.getForecastSalesAmount().toString()).matches()){
                throw new BusinessException("预估销售额填写格式有误,只能填写大于等于0的数字,并且最多保留两位小数");
            }
            if (null == reqVo.getApplyAmount()){
                throw new BusinessException("请填写费用申请金额");
            }
            if (!pattern.matcher(reqVo.getApplyAmount().toString()).matches()){
                throw new BusinessException("费用申请金额填写格式有误,只能填写大于等于0的数字,并且最多保留两位小数");
            }
        }else if (SfaActTaskEnum.actTypeEnum.display.getVal().equals(reqVo.getActType())){
            String text = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,1})?$";
            Pattern pattern=Pattern.compile(text);
            if (null == reqVo.getActFrequency()){
                throw new BusinessException("请填写任务执行频率(单位:天/1次)");
            }
            if (!pattern.matcher(reqVo.getActFrequency().toString()).matches()){
                throw new BusinessException("任务执行频率写格式有误,只能填写大于0的数字,并且最多保留一位小数");
            }
            if (reqVo.getActFrequency().compareTo(BigDecimal.ZERO)<=0){
                throw new BusinessException("任务执行频率写格式有误,只能填写大于0的数字,并且最多保留一位小数");
            }
        }else{
            throw new BusinessException("活动类型编码有误,系统不存在该活动类型");
        }
        if (CollectionUtil.listEmpty(reqVo.getSfaActRangeReqContainVos())&&CollectionUtil.listEmpty(reqVo.getSfaActRangeReqNotContainVos())){
            throw new BusinessException("活动范围不能为空");
        }
        if (SfaActTaskEnum.actTypeEnum.display.getVal().equals(reqVo.getActType())){
            if (CollectionUtil.listEmpty(reqVo.getSfaActProductReqVos())){
                throw new BusinessException("陈列活动,陈列要求不能为空");
            }
            int i = 1;
            for (SfaActProductReqVo productReqVo:reqVo.getSfaActProductReqVos()){
                if (StringUtil.isEmpty(productReqVo.getProductCode())){
                    throw new BusinessException("陈列活动,第"+i+"行陈列要求,产品编码不能为空");
                }
                if (StringUtil.isEmpty(productReqVo.getProductName())){
                    throw new BusinessException("陈列活动,第"+i+"行陈列要求,产品名称不能为空");
                }
                if (null == productReqVo.getMinNumber()){
                    throw new BusinessException("陈列活动,第"+i+"行陈列要求,最低陈列面数不能为空(只能填写大于0的正整数)");
                }
                String regex="^[1-9]+[0-9]*$";
                Pattern pattern=Pattern.compile(regex);
                if (!pattern.matcher(productReqVo.getMinNumber().toString()).matches()){
                    throw new BusinessException("陈列活动,第"+i+"行陈列要求格式有误(只能填写大于0的正整数)");
                }
            }
            if (CollectionUtil.listEmpty(reqVo.getSfaActFileReqVos())){
                throw new BusinessException("陈列活动,请上传对应示例图片");
            }
        }
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActTaskReqVo reqVo){
        this.saveCheck(reqVo);
        SfaActTaskEntity entity = CrmBeanUtil.copy(reqVo,SfaActTaskEntity.class);
        //TODO 编码
        String code = CodeUtil.createCode();
        entity.setActCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save(entity);
        this.saveData(reqVo,entity);
    }

    public void saveData(SfaActTaskReqVo reqVo,SfaActTaskEntity entity){
        //范围 包含
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSfaActRangeReqContainVos())){
            List<SfaActRangeEntity> sfaActRangeContainList = reqVo.getSfaActRangeReqContainVos().stream().map(o -> {
                SfaActRangeEntity actRangeEntity = new SfaActRangeEntity();
                CrmBeanUtil.copyProperties(o, actRangeEntity);
                actRangeEntity.setActCode(entity.getActCode());
                actRangeEntity.setRangeType(SfaCommonEnum.rangeTypeEnum.One.getVal());
                return actRangeEntity;
            }).collect(Collectors.toList());
            iSfaActRangeService.saveBatch(sfaActRangeContainList);
        }

        //范围 非包含
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSfaActRangeReqNotContainVos())){
            List<SfaActRangeEntity> sfaActRangeContainList = reqVo.getSfaActRangeReqNotContainVos().stream().map(o -> {
                SfaActRangeEntity actRangeEntity = new SfaActRangeEntity();
                CrmBeanUtil.copyProperties(o, actRangeEntity);
                actRangeEntity.setActCode(entity.getActCode());
                actRangeEntity.setRangeType(SfaCommonEnum.rangeTypeEnum.Two.getVal());
                return actRangeEntity;
            }).collect(Collectors.toList());
            iSfaActRangeService.saveBatch(sfaActRangeContainList);
        }

        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSfaActProductReqVos())){
            List<SfaActProductEntity> productEntityList = reqVo.getSfaActProductReqVos().stream().map(o -> {
                SfaActProductEntity productEntity = new SfaActProductEntity();
                CrmBeanUtil.copyProperties(o, productEntity);
                productEntity.setActCode(entity.getActCode());
                return productEntity;
            }).collect(Collectors.toList());
            iSfaActProductService.saveBatch(productEntityList);
        }

        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSfaActFileReqVos())){
            List<SfaActFileEntity> fileEntityList = reqVo.getSfaActFileReqVos().stream().map(o -> {
                SfaActFileEntity fileEntity = new SfaActFileEntity();
                CrmBeanUtil.copyProperties(o, fileEntity);
                fileEntity.setActCode(entity.getActCode());
                return fileEntity;
            }).collect(Collectors.toList());
            iSfaActFileService.saveBatch(fileEntityList);
        }
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActTaskReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaActTaskEntity entity = this.getById(reqVo.getId());
        if(Objects.isNull(entity)){
            throw new BusinessException("数据不存在");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyPropertiesIgnoreEmpty(reqVo,entity);
        this.updateById(entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo,entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActTaskReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaActTaskRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            throw new BusinessException("数据不存在");
        }
        sfaActTaskMapper.deleteProductsByParams(reqVo);
        List<String> actCodes = list.stream().map(SfaActTaskRespVo :: getActCode).collect(Collectors.toList());
        reqVo.setActCodes(actCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaActTaskReqVo reqVo){
        if (null!=reqVo&&(CollectionUtil.listNotEmptyNotSizeZero(reqVo.getActCodes())||StringUtil.isNotEmpty(reqVo.getActCode()))){
            //活动范围
            SfaActRangeReqVo rangeReqVo = new SfaActRangeReqVo();
            rangeReqVo.setActCode(reqVo.getActCode());
            rangeReqVo.setActCodes(reqVo.getActCodes());
            sfaActRangeMapper.deleteProductsByParams(rangeReqVo);
            //陈列活动-陈列要求
            SfaActProductReqVo productReqVo = new SfaActProductReqVo();
            productReqVo.setActCode(reqVo.getActCode());
            productReqVo.setActCodes(reqVo.getActCodes());
            sfaActProductMapper.deleteProductsByParams(productReqVo);
            //陈列活动-示例图片
            SfaActFileReqVo fileReqVo = new SfaActFileReqVo();
            fileReqVo.setActCode(reqVo.getActCode());
            fileReqVo.setActCodes(reqVo.getActCodes());
            sfaActFileMapper.deleteProductsByParams(fileReqVo);
        }
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActTaskReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为启用
        List<SfaActTaskEntity> sfaActTaskEntities = sfaActTaskMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActTaskEntities)){
            sfaActTaskEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActTaskEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActTaskReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为禁用
        List<SfaActTaskEntity> sfaActTaskEntities = sfaActTaskMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActTaskEntities)){
                sfaActTaskEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActTaskEntities);
    }
}
