package com.biz.crm.ai.controller;

import com.biz.crm.ai.service.SfaAiProductService;
import com.biz.crm.ai.vo.product.SfaAiProductVo;
import com.biz.crm.aop.CrmLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/9/29
 */
@Slf4j
@RestController
@RequestMapping("/ai/sfaAiProductController")
@Api(tags = "陈列任务ai识别商品映射;")
public class SfaAiProductController {

  @Resource
  private SfaAiProductService sfaAiProductService;

  @PostMapping("/save")
  @ApiOperation(value = "保存映射信息")
  @CrmLog
  public void save(@RequestBody SfaAiProductVo vo) {
    sfaAiProductService.bizSave(vo);
  }

  @GetMapping("/list")
  @ApiOperation(value = "映射信息")
  @CrmLog
  public List<SfaAiProductVo> list() {
    return sfaAiProductService.findAll();
  }
}
