package com.biz.crm.ai.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author sunx
 * @date 2021/9/26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_ai_task")
@CrmTable(name = "sfa_ai_task", tableNote = "ai识别任务信息")
public class SfaAiTaskEntity extends CrmBaseEntity<SfaAiTaskEntity> {

  @CrmColumn(name = "step_id", length = 100, note = "陈列任务执行id")
  private String stepId;

  @CrmColumn(name = "step_code", length = 100, note = "stepCode")
  private String stepCode;

  @CrmColumn(name = "execution_id", length = 100, note = "活动id")
  private String executionId;

  @CrmColumn(name = "client_code", length = 100, note = "客户编码")
  private String clientCode;

  @CrmColumn(name = "recognition_task_id", length = 100, note = "识别任务id")
  private String recognitionTaskId;

  @CrmColumn(name = "repeat_task_id", length = 100, note = "查重任务id")
  private String repeatTaskId;

  @CrmColumn(name = "task_status", length = 50, note = "ai识别任务状态")
  private String taskStatus;

  @CrmColumn(name = "err_msg", length = 250, note = "失败信息")
  private String errMsg;
}
