package com.biz.crm.ai.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.ai.model.SfaAiTaskEntity;
import com.biz.crm.ai.vo.AiCallBackDto;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import java.util.List;

/**
 * ai识别任务服务
 *
 * @author sunx
 * @date 2021/9/26
 */
public interface SfaAiTaskService extends IService<SfaAiTaskEntity> {

  /**
   * 开始执行陈列识别
   *
   * @param stepId                   执行任务id
   * @param stepCode                 stepCode
   * @param executionId              活动id
   * @param clientCode               客户编码
   * @param activityRequireReqVoList 活动图片信息
   */
  void startRecognitionTask(String stepId,
      String stepCode,
      String executionId,
      String clientCode,
      List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList);

  /**
   * 开始执行陈列识别new
   *
   * @param stepId                   执行任务id
   * @param stepCode                 stepCode
   * @param executionId              活动id
   * @param clientCode               客户编码
   * @param activityRequireReqVoList 活动图片信息
   */
  void startRecognitionTaskNew(String stepId,
      String stepCode,
      String executionId,
      String clientCode,
      List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList);

  /**
   * 陈列识别回调
   *
   * @param dto
   */
  void recognitionCallBack(AiCallBackDto dto);

  /**
   * 查重任务回调
   *
   * @param dto
   */
  void repeatCallBack(AiCallBackDto dto);

  /**
   * 测试后续逻辑
   *
   * @param taskId
   * @param status
   */
  void test(String taskId, String status);
}
