package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 方案活动兑付图片;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_cashing_picture")
@CrmTable(name = "sfa_as_cashing_picture", tableNote = "方案活动兑付图片",indexes = {
        @Index(name = "sfa_cashing_picture_index1",columnList ="cashing_id" )
})
public class SfaAsCashingPictureEntity extends CrmExtTenEntity<SfaAsCashingPictureEntity> {

    /**
     * 兑付id
     */
    @CrmColumn(name = "cashing_id", length = 100, note = "兑付id")
    private String cashingId;

    /**
     * 访问前缀
     */
    @CrmColumn(name = "url_path_prefix", length = 512, note = "访问前缀")
    private String urlPathPrefix;

    /**
     * 路径
     */
    @CrmColumn(name = "url_path", length = 512, note = "路径")
    private String urlPath;


    /**
     * 文件名称
     */
    @CrmColumn(name = "file_name", length = 200, note = "文件名称")
    private String fileName;

    /**
     * 对象名
     */
    @CrmColumn(name = "object_name", length = 512, note = "活动名称")
    private String objectName;

    /**
     * 文件后缀
     */
    @CrmColumn(name = "suffix", length = 32, note = "文件后缀")
    private String suffix;


}
