package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigInteger;

/**
 * 方案活动兑付产品;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_cashing_product")
@CrmTable(name = "sfa_as_cashing_product", tableNote = "方案活动兑付产品",indexes = {
        @Index(name = "sfa_cashing_product_index1",columnList = "cashing_id"),
        @Index(name = "sfa_cashing_product_index2",columnList = "product_code")
})
public class SfaAsCashingProductEntity extends CrmExtTenEntity<SfaAsCashingProductEntity> {

    /**
     * 兑付id
     */
    @CrmColumn(name = "cashing_id", length = 32, note = "兑付id")
    private String cashingId;
    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100, note = "产品名称")
    private String productName;
    /**
     * 数量
     */
    @CrmColumn(name = "product_num", mysqlType = "decimal(12,0)", oracleType = "NUMBER(12,0)", note = "数量")
    private BigInteger productNum;


}
