package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;
import javax.persistence.Transient;

/**
 * 方案活动执行;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_execution")
@CrmTable(name = "sfa_as_execution", tableNote = "方案活动执行",indexes = {
        @Index(name ="sfa_as_execution_index1",columnList ="activity_code" ),
        @Index(name ="sfa_as_execution_index2",columnList ="terminal_code" ),
        @Index(name ="sfa_as_execution_index3",columnList ="org_code" ),
        @Index(name ="sfa_as_execution_index4",columnList ="pos_code" ),
        @Index(name ="sfa_as_execution_index5",columnList = "CREATE_DATE")
})
public class SfaAsExecutionEntity extends CrmExtTenEntity<SfaAsExecutionEntity> implements VisitStepListener.VisitStepListenerCommittedData {

    private static final long serialVersionUID = 2855138227639481552L;
    /**
     * 活动编码
     */
    @CrmColumn(name = "activity_code", length = 32, note = "活动编码")
    private String activityCode;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "终端编码")
    private String terminalCode;
    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name", length = 100, note = "终端名称")
    private String terminalName;
    /**
     * 参与类型(1:免费参与;2:协议参与)
     */
    @CrmColumn(name = "participate_in_type", length = 10, note = "参与类型")
    private String participateInType;
    /**
     * 陈列类型
     */
    @CrmColumn(name = "display_type", length = 100, note = "陈列类型")
    private String displayType;
    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 100, note = "人员账号")
    private String userName;
    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 100, note = "人员姓名")
    private String realName;
    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100, note = "职位名称")
    private String posName;
    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码")
    private String posCode;
    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "组织名称")
    private String orgName;
    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "组织编码")
    private String orgCode;

    /**
     * 执行时间
     */
    @CrmColumn(name = "execution_Date", length = 50, note = "执行时间")
    private String executionDate;

    /**
     * 拜访ID
     */
    @CrmColumn(name = "visit_plan_info_id", length = 50, note = "拜访ID")
    private String visitPlanInfoId;


    @JsonIgnore
    @Transient
    @TableField(exist = false)
    private String stepCode;

    @JsonIgnore
    @Transient
    @TableField(exist = false)
    private String clientSubclass;


    @JsonIgnore
    @Transient
    @TableField(exist = false)
    private String clientSubclassName;



    @Override
    @JsonIgnore
    @Transient
    public String getClientCode() {
        return this.terminalCode;
    }

    @Override
    @Transient
    public void setClientCode(String clientCode) {
        this.terminalCode = clientCode;
    }

    @Override
    @JsonIgnore
    @Transient
    public String getClientName() {
        return this.terminalName;
    }

    @Override
    @Transient
    public void setClientName(String clientName) {
        this.terminalName = clientName;
    }

    @Override
    @JsonIgnore
    @Transient
    public String getClientType() {
        return SfaVisitEnum.ClientType.TERMINAL.getVal();
    }

    @Override
    @Transient
    public void setClientType(String clientType) {

    }

    @Override
    @JsonIgnore
    @Transient
    public String getClientTypeName() {
        return SfaVisitEnum.ClientType.TERMINAL.getDesc();
    }

    @Override
    @Transient
    public void setClientTypeName(String clientTypeName) {

    }




}
