package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 方案活动执行图片;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_execution_picture")
@CrmTable(name = "sfa_as_execution_picture", tableNote = "方案活动执行图片",indexes = {
        @Index(name = "sfa_execution_picture_index1",columnList = "execution_id")
})
public class SfaAsExecutionPictureEntity extends CrmExtTenEntity<SfaAsExecutionPictureEntity> {

    /**
     * 执行id
     */
    @CrmColumn(name = "execution_id", length = 32, note = "执行id")
    private String executionId;

    /**
     * 陈列类型
     */
    @CrmColumn(name = "display_type", length = 32, note = "陈列类型")
    private String displayType;

    /**
     * 访问前缀
     */
    @CrmColumn(name = "url_path_prefix", length = 512, note = "访问前缀")
    private String urlPathPrefix;

    /**
     * 路径
     */
    @CrmColumn(name = "url_path", length = 512, note = "路径")
    private String urlPath;

    /**
     * 文件名称
     */
    @CrmColumn(name = "file_name", length = 200, note = "文件名称")
    private String fileName;

    /**
     * 对象名
     */
    @CrmColumn(name = "object_name", length = 512, note = "对象名")
    private String objectName;

    /**
     * 文件后缀
     */
    @CrmColumn(name = "suffix", length = 32, note = "文件后缀")
    private String suffix;


}
