package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 方案活动协议签字图片地址;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_treaty_sign")
@CrmTable(name = "sfa_as_treaty_sign", tableNote = "方案活动协议签字图片地址",indexes = {
        @Index(name = "sfa_as_treaty_sign_index1",columnList = "treaty_id")
})
public class SfaAsTreatySignEntity extends CrmExtTenEntity<SfaAsTreatySignEntity> {

    /**
     * 协议id
     */
    @CrmColumn(name = "treaty_id", length = 32, note = "协议id")
    private String treatyId;
    /**
     * 签字人名
     */
    @CrmColumn(name = "sign_name", length = 32, note = "签字人名")
    private String signName;
    /**
     * 访问前缀
     */
    @CrmColumn(name = "url_path_prefix", length = 512, note = "访问前缀")
    private String urlPathPrefix;

    /**
     * 路径
     */
    @CrmColumn(name = "url_path", length = 512, note = "路径")
    private String urlPath;

    /**
     * 文件名称
     */
    @CrmColumn(name = "file_name", length = 200, note = "文件名称")
    private String fileName;

    /**
     * 对象名
     */
    @CrmColumn(name = "object_name", length = 512, note = "对象名")
    private String objectName;

    /**
     * 文件后缀
     */
    @CrmColumn(name = "suffix", length = 32, note = "文件后缀")
    private String suffix;

    /**
     * 类型（SIGN_签名照/PDF_文件/IMAGE_图片）
     */
    @CrmColumn(name = "file_type", length = 10, note = "类型（SIGN_签名照/PDF_文件/IMAGE_图片）")
    private String fileType;
}
