package com.biz.crm.asexecution.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.asexecution.mapper.SfaAsCashingMapper;
import com.biz.crm.asexecution.model.SfaAsCashingEntity;
import com.biz.crm.asexecution.model.SfaAsCashingPictureEntity;
import com.biz.crm.asexecution.model.SfaAsCashingProductEntity;
import com.biz.crm.asexecution.service.ISfaAsCashingPictureService;
import com.biz.crm.asexecution.service.ISfaAsCashingProductService;
import com.biz.crm.asexecution.service.ISfaAsCashingService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsCashingReqVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingPictureRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingProductRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 方案活动兑付;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaAsCashingServiceExpandImpl")
@Transactional
public class SfaAsCashingServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaAsCashingMapper, SfaAsCashingEntity> implements ISfaAsCashingService {

    @Resource
    private SfaAsCashingMapper sfaAsCashingMapper;

    @Resource
    private ISfaAsCashingProductService sfaAsCashingProductService;

    @Resource
    private ISfaAsCashingPictureService sfaAsCashingPictureService;

    /**
     * 活动对付报表
     *
     * @param params
     * @return
     */
    @Override
    public PageResult<SfaAsCashingRespVo> report(SfaAsCashingReqVo params) {
        Page<SfaAsCashingRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<SfaAsCashingRespVo> list = sfaAsCashingMapper.report(page, params);
        list.forEach(o -> {
            //兑付方式
            o.setPaymentMethod(SfaActivityEnum.paymentMethod.GETMAP.get(o.getPaymentMethod()));
        });
        return PageResult.<SfaAsCashingRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 根据兑付ID查询兑付详情
     *
     * @param cashId
     * @return
     */
    @Override
    public SfaAsCashingRespVo findById(String cashId) {
        SfaAsCashingReqVo params = new SfaAsCashingReqVo();
        params.setId(cashId);
        Page<SfaAsCashingRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<SfaAsCashingRespVo> list = sfaAsCashingMapper.report(page, params);
        SfaAsCashingRespVo respVo = list.get(0);
        //兑付方式
        respVo.setPaymentMethod(SfaActivityEnum.paymentMethod.GETMAP.get(respVo.getPaymentMethod()));
        //查询图片
        List<SfaAsCashingPictureEntity> pictureEntities = sfaAsCashingPictureService.lambdaQuery()
                .eq(SfaAsCashingPictureEntity::getCashingId, cashId).list();
        respVo.setAsCashingPictureList(CrmBeanUtil.copyList(pictureEntities, SfaAsCashingPictureRespVo.class));
        //查询商品
        List<SfaAsCashingProductEntity> productEntities = sfaAsCashingProductService.lambdaQuery()
                .eq(SfaAsCashingProductEntity::getCashingId, cashId).list();
        respVo.setAsCashingProductList(CrmBeanUtil.copyList(productEntities, SfaAsCashingProductRespVo.class));
        return respVo;
    }
}
