package com.biz.crm.asexecution.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.actscheme.model.SfaActSchemePosApplyEntity;
import com.biz.crm.actscheme.service.ISfaActSchemePosApplyService;
import com.biz.crm.asexecution.mapper.SfaAsExecutionMapper;
import com.biz.crm.asexecution.model.*;
import com.biz.crm.asexecution.service.*;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.component.impl.OrderVisitStepExecutor;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeProductRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.*;
import com.biz.crm.nebular.sfa.asexecution.resp.*;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.nebular.upload.vo.WordTemplateDataVo;
import com.biz.crm.upload.file.OfficeFileFeign;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.cglib.beans.BeanMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 方案活动执行;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaAsExecutionServiceExpandImpl")
@Transactional
public class SfaAsExecutionServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaAsExecutionMapper, SfaAsExecutionEntity> implements ISfaAsExecutionService {

    @Resource
    protected ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Autowired
    private ISfaAsExecutionProductService sfaAsExecutionProductService;
    @Autowired
    private ISfaAsExecutionPictureService sfaAsExecutionPictureService;


    @Autowired
    private ISfaAsTreatySignService sfaAsTreatySignService;
    @Autowired
    private ISfaAsTreatyDisplayProductService sfaAsTreatyDisplayProductService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaAsTreatyConvertProductService sfaAsTreatyConvertProductService;

    @Autowired
    private ISfaAsCashingService sfaAsCashingService;
    @Autowired
    private ISfaAsCashingProductService sfaAsCashingProductService;
    @Autowired
    private ISfaAsCashingPictureService sfaAsCashingPictureService;

    @Autowired
    private ISfaAsStopService sfaAsStopService;

    @Autowired
    private ISfaActSchemePosApplyService sfaActSchemePosApplyService;


    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;

    @Autowired
    private OfficeFileFeign officeFileFeign;

    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;

    @Autowired
    private MdmUserFeign mdmUserFeign;

    @Autowired
    private ISfaVisitStepFromService sfaVisitStepFromService;


    /**
     * 活动协议保存
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSfaAsTreaty(SfaAsTreatyReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userRedis.getUsername());
        MdmUserRespVo mdmUserRespVo = ApiResultUtil.objResult(mdmUserFeign.query(mdmUserReqVo));
        reqVo.setCurrUserPhone(mdmUserRespVo.getUserPhone());
        AssertUtils.isNotEmpty(reqVo.getActivityCode(), "活动编码为空");
        reqVo.setTreatySource(SfaCommonEnum.actTreatySource.SFA_PROGRAMME.getValue());
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = sfaActSchemePosApplyService
                .lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, reqVo.getActivityCode()).one();
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("未查询到对应活动[" + reqVo.getActivityCode() + "]");
        }
        reqVo.setPaymentMethod(actSchemePosApplyEntity.getPaymentMethod());
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalName(), "终端名称为空");
        List<SfaAsTreatyEntity> asTreatyList = sfaAsTreatyService
                .lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsTreatyEntity::getTerminalCode, reqVo.getTerminalCode()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(asTreatyList)) {
            throw new BusinessException("门店[" + reqVo.getTerminalCode() + "-" + reqVo.getTerminalName() + "],对应活动[" + reqVo.getActivityCode() + "],已签署协议,不能重复签署");
        }
        AssertUtils.isNotEmpty(reqVo.getDisplayBrand(), "陈列品牌为空");
        //AssertUtils.isNotEmpty(reqVo.getDisplayItem(), "陈列品项为空");
        //AssertUtils.isNotEmpty(reqVo.getAsTreatyDisplayProductList(), "陈列产品为空");
        AssertUtils.isNotEmpty(reqVo.getDisplayPlace(), "陈列位置为空");
        AssertUtils.isNotEmpty(reqVo.getDisplaySpecs(), "陈列规格为空");
        AssertUtils.isNotEmpty(reqVo.getDisplayNumber(), "陈列件数为空");
        AssertUtils.isNotEmpty(reqVo.getDisplayStartTime(), "陈列开始时间为空");
        AssertUtils.isNotEmpty(reqVo.getDisplayEndTime(), "陈列结束时间为空");
        AssertUtils.isNotEmpty(reqVo.getCurrUserPhone(), "业务员手机号不能为空");
        AssertUtils.isNotEmpty(reqVo.getDealerCode(), "经销商编码不能为空!");
        AssertUtils.isNotEmpty(reqVo.getDealerName(), "经销商名称不能为空!");

        //查询门店信息
        MdmTerminalVo mdmTerminalVo = ApiResultUtil.objResult(mdmTerminalFeign.query(null, reqVo.getTerminalCode()));
        reqVo.setTerminalAddr(mdmTerminalVo.getTerminalAddress());
        if (CollectionUtil.listNotEmpty(mdmTerminalVo.getContacts())) {
            //获取主联系人
            List<MdmTerminalContactVo> contactVos = mdmTerminalVo.getContacts().stream()
                    .filter(o -> o.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue()))
                    .collect(Collectors.toList());
            if (CollectionUtil.listNotEmpty(contactVos)) {
                MdmTerminalContactVo terminalContactVo = contactVos.get(0);
                reqVo.setTerminalPhone(terminalContactVo.getContactPhone());
            }
        }

        LocalDate displayStartTime = null;
        LocalDate displayEndTime = null;
        LocalDate now = LocalDate.now();
        try {
            displayStartTime = LocalDate.parse(reqVo.getDisplayStartTime());
            displayEndTime = LocalDate.parse(reqVo.getDisplayEndTime());
        } catch (Exception e) {
            throw new BusinessException("陈列时间错误");
        }
        if (!displayStartTime.isBefore(displayEndTime)) {
            throw new BusinessException("陈列开始时间不能大于陈列结束时间");
        }
        if (now.isAfter(displayEndTime)) {
            throw new BusinessException("陈列结束时间不可小于当前时间");
        }
        AssertUtils.isNotEmpty(reqVo.getDisplayMonth(), "陈列月份为空");
        /**现金兑付*/
        if (SfaActivityEnum.paymentMethod.XJ.getVal().equals(actSchemePosApplyEntity.getPaymentMethod())) {
            if (null == reqVo.getMonthPayAmount()) {
                throw new BusinessException("每月支付现金为空");
            }
            if (null == reqVo.getTotalAmount()) {
                throw new BusinessException("合计奖励现金为空");
            }
            AssertUtils.isNotEmpty(reqVo.getPayee(), "奖励收款人为空");
            AssertUtils.isNotEmpty(reqVo.getContactPhone(), "联系电话为空");
        } else {
            AssertUtils.isNotEmpty(reqVo.getAsTreatyConvertProductList(), "货物兑换产品为空");
        }
        if (null == reqVo.getAsTreatySign()) {
            throw new BusinessException("店主签字为空");
        }
        SfaAsTreatyEntity entity = CrmBeanUtil.copy(reqVo, SfaAsTreatyEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setTreatyCode(CodeUtil.generateCode(SfaCodeEnum.schemeCode.SCHEME_ACTIVITY_TREATY_CODE.getVal()));
        //entity.setTreatyCode("XY00001");

        entity.setTreatyStatus(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal());
        sfaAsTreatyService.save(entity);
        String id = entity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAsTreatyDisplayProductList())) {
            reqVo.getAsTreatyDisplayProductList().forEach(o -> {
                o.setId(null);
            });
            List<SfaAsTreatyDisplayProductEntity> asTreatyDisplayProductList = CrmBeanUtil.copyList(reqVo.getAsTreatyDisplayProductList(), SfaAsTreatyDisplayProductEntity.class);
            asTreatyDisplayProductList.forEach(data -> {
                data.setTreatyId(id);
            });
            sfaAsTreatyDisplayProductService.saveBatch(asTreatyDisplayProductList);
        }

        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAsTreatyConvertProductList())) {
            reqVo.getAsTreatyConvertProductList().forEach(o -> {
                o.setId(null);
            });
            List<SfaAsTreatyConvertProductEntity> asTreatyConvertProductList = CrmBeanUtil.copyList(reqVo.getAsTreatyConvertProductList(), SfaAsTreatyConvertProductEntity.class);
            asTreatyConvertProductList.forEach(data -> {
                data.setTreatyId(id);
                if (StringUtils.isEmpty(data.getItemType())) {
                    throw new BusinessException("商品行类型不能为空(1:支付货品;2:奖励货品)");
                }
            });
            sfaAsTreatyConvertProductService.saveBatch(asTreatyConvertProductList);
        }

        //保存数字签名
        SfaAsTreatySignEntity asTreatySignEntity = CrmBeanUtil.copy(reqVo.getAsTreatySign(), SfaAsTreatySignEntity.class);
        asTreatySignEntity.setTreatyId(id);
        asTreatySignEntity.setFileType(SfaActivityEnum.SignFileType.SIGN.getVal());
        sfaAsTreatySignService.save(asTreatySignEntity);

        //生成pdf并上传
        createPdf(reqVo, entity);
        if (StringUtils.isEmpty(entity.getUrlPath())) {
            throw new BusinessException("协议PDF文件生成失败!");
        }
        //log.info(entity.getUrlPathPrefix() + entity.getUrlPath());
        sfaAsTreatyService.updateById(entity);
        SfaAsStopReqVo asStopReqVo = CrmBeanUtil.copy(reqVo, SfaAsStopReqVo.class);
        asStopReqVo.setStopState(YesNoEnum.yesNoEnum.ZERO.getValue());
        this.saveAsStop(asStopReqVo);
    }

    /**
     * pdf协议生成
     *
     * @param reqVo
     * @param entity
     */
    private void createPdf(SfaAsTreatyReqVo reqVo, SfaAsTreatyEntity entity) {
        SfaAsTreatySignReqVo asTreatySign = reqVo.getAsTreatySign();
        TemplateTreatyVo templateTreatyVo = CrmBeanUtil.copy(reqVo, TemplateTreatyVo.class);
        templateTreatyVo.setRemarks(StringUtils.isEmpty(templateTreatyVo.getRemarks()) ? "无" : templateTreatyVo.getRemarks());
        //当前登录人
        UserRedis userRedis = UserUtils.getUser();
        String currUserName = formatStrLength(userRedis.getRealname(), 10);
        String currUserPhone = templateTreatyVo.getCurrUserPhone();
        currUserPhone = currUserPhone + "&#160;&#160;&#160;&#160;&#160;&#160;";
        templateTreatyVo.setCurrUserPhone(currUserPhone);
        templateTreatyVo.setCurrUserName(currUserName);
        //陈列产品处理
        if (StringUtils.isEmpty(reqVo.getDisplayItem())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayBrand());
        } else if (CollectionUtil.listEmpty(reqVo.getAsTreatyDisplayProductList())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayItem());
        } else if (CollectionUtil.listNotEmpty(reqVo.getAsTreatyDisplayProductList())) {
            List<String> productNames = Lists.newArrayList();
            reqVo.getAsTreatyDisplayProductList().forEach(o -> {
                productNames.add(o.getProductName());
            });
            String displayInfo = Joiner.on("、").join(productNames);
            templateTreatyVo.setDisplayInfo(displayInfo);
        }
        //转换为Map
        Map<String, Object> dataMap = Maps.newHashMap();
        if (templateTreatyVo != null) {
            BeanMap beanMap = BeanMap.create(templateTreatyVo);
            for (Object key : beanMap.keySet()) {
                dataMap.put(key.toString(), beanMap.get(key));
            }
        }
        //时间处理 年 /月 /日
        String[] startTime = reqVo.getDisplayStartTime().split("-");
        String[] endTime = reqVo.getDisplayEndTime().split("-");
        dataMap.put("startYear", startTime[0]);
        dataMap.put("startMonth", startTime[1]);
        dataMap.put("startDay", startTime[2]);
        dataMap.put("endYear", endTime[0]);
        dataMap.put("endMonth", endTime[1]);
        dataMap.put("endDay", endTime[2]);
        //当前时间
        String date2Str = DateUtil.date2Str(DateUtil.date_sdf_wz);
        dataMap.put("currDate", date2Str);
        boolean equals = SfaActivityEnum.paymentMethod.XJ.getVal().equals(reqVo.getPaymentMethod());
        //商品处理
        if (!equals) {
            List<SfaAsTreatyConvertProductReqVo> asTreatyConvertProductList = reqVo.getAsTreatyConvertProductList();
            Map<String, List<SfaAsTreatyConvertProductReqVo>> listMap = asTreatyConvertProductList.stream()
                    .collect(Collectors.groupingBy(SfaAsTreatyConvertProductReqVo::getItemType));
            listMap.forEach((k, v) -> {
                List<TemplateTreatyProductVo> productVos = v.stream().map(sfaAsTreatyConvertProductReqVo -> {
                    TemplateTreatyProductVo templateTreatyProductVo = CrmBeanUtil.copy(sfaAsTreatyConvertProductReqVo, TemplateTreatyProductVo.class);
                    if (org.apache.commons.lang3.StringUtils.isBlank(templateTreatyProductVo.getSpec())) {
                        templateTreatyProductVo.setSpec("无");
                    }
                    return templateTreatyProductVo;
                }).collect(Collectors.toList());
                if (SfaActivityEnum.bpItemType.bp.getVal().equals(k)) {
                    dataMap.put("products", productVos);
                } else {
                    dataMap.put("gifts", productVos);
                }
            });
        }
        if (!dataMap.containsKey("gifts") || dataMap.get("gifts") == null) {
            dataMap.put("gifts", new ArrayList<>());
        } else {
            List<TemplateTreatyProductVo> temp = (List<TemplateTreatyProductVo>) dataMap.get("gifts");
            if (CollectionUtil.listNotEmptyNotSizeZero(temp)) {
                dataMap.put("gifts", temp);
            }
        }
        WordTemplateDataVo dataVo = new WordTemplateDataVo();
        dataVo.setLeftOffset(340);
        dataVo.setTopOffset(equals ? -10 : -20);
        dataVo.setTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getVal() : SfaActivityEnum.TemplateType.PRODUCT.getVal());
        dataVo.setZipTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getDesc() : SfaActivityEnum.TemplateType.PRODUCT.getDesc());
        dataVo.setFileName(entity.getTreatyCode());
        dataVo.setTabText("代表（签字）");
        dataVo.setSginImageUrl(asTreatySign.getUrlPathPrefix() + asTreatySign.getUrlPath());
        dataVo.setDataMap(dataMap);
        List<UploadVo> uploadVos = ApiResultUtil.objResult(officeFileFeign.createWordDocxToPdfFile(dataVo), true);
        if (!CollectionUtils.isEmpty(uploadVos)) {
            UploadVo uploadVo = uploadVos.get(0);
            entity.setObjectName(uploadVo.getObjectName());
            entity.setUrlPath(uploadVo.getUrlPath());
            entity.setUrlPathPrefix(uploadVo.getUrlPathPrefix());
        }
    }

    private String formatStrLength(String str, int len) {
        //总长度
        int length = str.length();
        for (int i = 0, j = len - length; i < j; i++) {
            str = str + "&#160;";
        }
        return str;
    }


    /**
     * 活动在执行
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSfaAsExecution(SfaAsExecutionReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty(reqVo.getActivityCode(), "活动编码为空");
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = sfaActSchemePosApplyService
                .lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, reqVo.getActivityCode()).one();
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("未查询到对应活动[" + reqVo.getActivityCode() + "]");
        }
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalName(), "终端名称为空");
//        if(org.apache.commons.lang3.StringUtils.isBlank(reqVo.getFormId())){
//            throw new BusinessException("请指定表单id");
//        }
        //查询当前网点
        Result<MdmTerminalVo> result = mdmTerminalFeign.query(null, reqVo.getTerminalCode());
        if (!result.isSuccess() || null == result.getResult()) {
            throw new BusinessException("未查询到对应终端[" + reqVo.getTerminalCode() + "]");
        }
        MdmTerminalVo terminalVo = result.getResult();
//        //距离检查
//        this.checkDistance(reqVo,terminalVo);
        List<SfaAsExecutionEntity> asExecutionEntities = this.lambdaQuery()
                .eq(SfaAsExecutionEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsExecutionEntity::getTerminalCode, reqVo.getTerminalCode()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(asExecutionEntities)) {
            List<SfaAsExecutionRespVo> asExecutionList = CrmBeanUtil.copyList(asExecutionEntities, SfaAsExecutionRespVo.class);
            reqVo.setParticipateInType(asExecutionList.get(0).getParticipateInType());
        } else {
            AssertUtils.isNotEmpty(reqVo.getParticipateInType(), "参与类型为空");
            if (!SfaActivityEnum.participateInType.GETMAP.containsKey(reqVo.getParticipateInType())) {
                throw new BusinessException("参与类型有误");
            }
        }
        AssertUtils.isNotEmpty(reqVo.getAsExecutionProductList(), "方案活动执行产品数据采集为空");
        AssertUtils.isNotEmpty(reqVo.getDisplayType(), "陈列类型为空");
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
        AssertUtils.isNotEmpty(reqVo.getAsExecutionPictureList(), "方案活动执行图片为空");

        SfaAsExecutionEntity entity = CrmBeanUtil.copy(reqVo, SfaAsExecutionEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        entity.setExecutionDate(now);
        entity.setVisitPlanInfoId(reqVo.getVisitId());
        this.save(entity);
        String id = entity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAsExecutionProductList())) {
            List<SfaAsExecutionProductEntity> asExecutionProductList = CrmBeanUtil.copyList(reqVo.getAsExecutionProductList(), SfaAsExecutionProductEntity.class);
            asExecutionProductList.forEach(data -> {
                data.setId(null);
                data.setExecutionId(id);
            });
            sfaAsExecutionProductService.saveBatch(asExecutionProductList);
            //订单信息
            OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo> dataReq = new OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>();
            //dataReq.setClientId(terminalVo.getId());
            dataReq.setClientCode(terminalVo.getTerminalCode());
            dataReq.setClientName(terminalVo.getTerminalName());
            dataReq.setClientType(terminalVo.getTerminalType());
            //dataReq.setClientPhoto(terminalVo.getShopImagePath());
            List<MdmTerminalSupplyVo> supplys = terminalVo.getSupplys();
            if (CollectionUtil.listNotEmptyNotSizeZero(supplys)) {
                MdmTerminalSupplyVo supplyVo = supplys.get(0);
                dataReq.setCustomerCode(supplyVo.getCustomerCode());
                dataReq.setCustomerName(supplyVo.getCustomerName());
            }
            List<MdmTerminalContactVo> contacts = terminalVo.getContacts();
            if (CollectionUtil.listNotEmptyNotSizeZero(contacts)) {
                MdmTerminalContactVo terminalContactVo = contacts.get(0);
                for (MdmTerminalContactVo contact : contacts) {
                    if (YesNoEnum.YesNoCodeNumberEnum.YES.getValue().equals(contact.getContactMain())) {
                        terminalContactVo = contact;
                    }
                }
                dataReq.setContacts(terminalContactVo.getContactName());
                dataReq.setTelephone(terminalContactVo.getContactPhone());
                //收货地址
                //期望收货时间
            }
            //dataReq.setStartOrderTime(actSchemePosApplyEntity.getActivityStartTime());
            //dataReq.setEndOrderTime(actSchemePosApplyEntity.getActivityEndTime());
            dataReq.setId(entity.getId());
            BigDecimal totalPrice = BigDecimal.ZERO;
            List<SfaActSchemeProductRespVo> sfaVisitStepOrderItems = new ArrayList<>();
            for (SfaAsExecutionProductReqVo productReqVo : reqVo.getAsExecutionProductList()) {
                if (ObjectUtils.isEmpty(productReqVo.getPrice())) {
                    throw new BusinessException("商品价格不能为空!");
                }
                if (ObjectUtils.isEmpty(productReqVo.getProductNum())) {
                    throw new BusinessException("商品数量不能为空!");
                }
                SfaActSchemeProductRespVo itemReqVo = CrmBeanUtil.copy(productReqVo, SfaActSchemeProductRespVo.class);
                String productNum = productReqVo.getProductNum().toString();
                itemReqVo.setQuantity(new BigDecimal(productNum));
                //查询商品
                MdmProductRespVo mdmProductRespVo = mdmProductFeign.detail(null, productReqVo.getProductCode()).getResult();
                if (null != mdmProductRespVo) {
                    itemReqVo.setSeriesCode(mdmProductRespVo.getProductLevelCode());
                    itemReqVo.setSeriesName(mdmProductRespVo.getProductLevelName());
                    itemReqVo.setUnit(mdmProductRespVo.getSaleUnit());
                    itemReqVo.setUnitName(mdmProductRespVo.getSaleUnitName());
                }
                itemReqVo.setPrice(productReqVo.getPrice().toString());
                totalPrice = totalPrice.add(productReqVo.getPrice().multiply(itemReqVo.getQuantity()));
                sfaVisitStepOrderItems.add(itemReqVo);
            }
            dataReq.setTotalPrice(totalPrice);
            dataReq.setVisitPlanInfoId(reqVo.getVisitId());
            dataReq.setActSchemeProductList(sfaVisitStepOrderItems);
            orderVisitStepExecutor.executeForAs(dataReq);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAsExecutionPictureList())) {
            List<SfaAsExecutionPictureEntity> asExecutionPictureList = CrmBeanUtil.copyList(reqVo.getAsExecutionPictureList(), SfaAsExecutionPictureEntity.class);
            asExecutionPictureList.forEach(data -> {
                data.setExecutionId(id);
            });
            sfaAsExecutionPictureService.saveBatch(asExecutionPictureList);
        }
        //拜访场景需要执行的业务
        this.visitProcess(reqVo.getVisitId());
        //触发监听器
        this.doListener(entity);
        SfaAsStopReqVo asStopReqVo = CrmBeanUtil.copy(reqVo, SfaAsStopReqVo.class);
        asStopReqVo.setStopState(YesNoEnum.yesNoEnum.ZERO.getValue());
        this.saveAsStop(asStopReqVo);
    }


    /**
     * 距离校验
     *
     * @param reqVo
     * @param terminalVo
     */
    private void checkDistance(SfaAsExecutionReqVo reqVo, MdmTerminalVo terminalVo) {

        //判断拜访客户经纬度不为空
        if (terminalVo != null && terminalVo.getLatitude() != null && terminalVo.getLatitude() != null) {
            SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, reqVo.getFormId()).one();
            if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
                if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
                    if (org.apache.commons.lang3.StringUtils.isBlank(reqVo.getLongitude())) {
                        throw new BusinessException("经度为空");
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank(reqVo.getLatitude())) {
                        throw new BusinessException("纬度为空");
                    }
                    BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前步骤配置的距离:{}", distance);
                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}", reqVo.getLongitude(), reqVo.getLatitude(), terminalVo.getLongitude(), terminalVo.getLatitude());
                    double data = LocationUtils.getDistance(new BigDecimal(reqVo.getLongitude()),
                            new BigDecimal(reqVo.getLatitude()), new BigDecimal(terminalVo.getLongitude()), new BigDecimal(terminalVo.getLatitude()));
                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前位置距离拜访客户的距离:{}", nowDistance);
                    if (distance.compareTo(nowDistance) == -1) {
                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
                    }
                }
            }
        }
    }

    /**
     * 调用监听器
     *
     * @param entity
     */
    protected void doListener(SfaAsExecutionEntity entity) {
        SfaAsExecutionEntity committedData = CrmBeanUtil.copy(entity, SfaAsExecutionEntity.class);
        if (null == committedData) {
            return;
        }
        //方案活动特殊处理，只需要以活动编码和客户编码的维度来查询数据
        committedData.setId(committedData.getActivityCode());
        SfaClientData clientData = SfaClientHelper.loadClientDataNotRequired(committedData.getClientType(), committedData.getClientCode());
        if (null != clientData) {
            committedData.setClientSubclass(clientData.getClientSubclass());
            committedData.setClientSubclassName(clientData.getClientSubclassName());
        }
        String stepCode = SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DEF_PROGRAMME.getVal();
        committedData.setStepCode(stepCode);

        List<VisitStepListener.VisitStepListenerCommittedData> committedDataList = Lists.newArrayList(committedData);
        List<AbstractVisitStepListener> listeners = AbstractVisitStepListener.getListeners(stepCode);
        for (AbstractVisitStepListener listener : listeners) {
            if (null == listener) {
                continue;
            }
            VisitStepListener.VisitStepListenerCommittedEvent committedEvent = new VisitStepListener.VisitStepListenerCommittedEvent();
            committedEvent.setEntities(committedDataList);
            listener.committed(committedEvent);
        }
    }

    /**
     * 拜访场景需要执行的业务
     *
     * @param visitId
     */
    protected void visitProcess(String visitId) {
        if (org.apache.commons.lang3.StringUtils.isBlank(visitId)) {
            return;
        }
        this.sfaVisitPlanInfoService.updateStepStatus(visitId, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DEF_PROGRAMME);
    }

    /**
     * 活动兑付
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSfaAsCashing(SfaAsCashingReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getActivityCode(), "活动编码为空");
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = sfaActSchemePosApplyService
                .lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, reqVo.getActivityCode()).one();
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("未查询到对应活动[" + reqVo.getActivityCode() + "]");
        }
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalName(), "终端名称为空");
        //查询门店信息
        MdmTerminalVo mdmTerminalVo = ApiResultUtil.objResult(mdmTerminalFeign.query(null, reqVo.getTerminalCode()));
        reqVo.setTerminalAddr(mdmTerminalVo.getTerminalAddress());
        if (CollectionUtil.listNotEmpty(mdmTerminalVo.getContacts())) {
            //获取主联系人
            List<MdmTerminalContactVo> contactVos = mdmTerminalVo.getContacts().stream()
                    .filter(o -> o.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue()))
                    .collect(Collectors.toList());
            if (CollectionUtil.listNotEmpty(contactVos)) {
                MdmTerminalContactVo terminalContactVo = contactVos.get(0);
                reqVo.setTerminalUser(terminalContactVo.getContactName());
                reqVo.setTerminalPhone(terminalContactVo.getContactPhone());
            }
        }

        /**现金兑付*/
        if (SfaActivityEnum.paymentMethod.XJ.getVal().equals(actSchemePosApplyEntity.getPaymentMethod())) {
            if (null == reqVo.getTransferAmount()) {
                throw new BusinessException("转账金额为空");
            }
        } else {
            AssertUtils.isNotEmpty(reqVo.getAsCashingProductList(), "兑付产品为空");
        }
        AssertUtils.isNotEmpty(reqVo.getAsCashingPictureList(), "活动兑付图片为空");

        SfaAsCashingEntity entity = CrmBeanUtil.copy(reqVo, SfaAsCashingEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        sfaAsCashingService.save(entity);
        String id = entity.getId();

        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAsCashingProductList())) {
            List<SfaAsCashingProductEntity> asCashingEntityList = CrmBeanUtil.copyList(reqVo.getAsCashingProductList(), SfaAsCashingProductEntity.class);
            asCashingEntityList.forEach(data -> {
                data.setCashingId(id);
                data.setId(null);
            });
            sfaAsCashingProductService.saveBatch(asCashingEntityList);
        }

        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAsCashingPictureList())) {
            List<SfaAsCashingPictureEntity> asCashingPictureList = CrmBeanUtil.copyList(reqVo.getAsCashingPictureList(), SfaAsCashingPictureEntity.class);
            asCashingPictureList.forEach(data -> {
                data.setCashingId(id);
                data.setId(null);
            });
            sfaAsCashingPictureService.saveBatch(asCashingPictureList);
        }
        //查询活动协议修改状态为已兑付
        sfaAsTreatyService.lambdaUpdate().eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsTreatyEntity::getTerminalCode, reqVo.getTerminalCode())
                .set(SfaAsTreatyEntity::getTreatyStatus, SfaActivityEnum.TreatyStatus.CASHED.getVal())
                .update();
        //修改记录表里状态为已终止
//        SfaAsStopEntity asStop = sfaAsStopService
//                .lambdaQuery().eq(SfaAsStopEntity::getActivityCode, reqVo.getActivityCode())
//                .eq(SfaAsStopEntity::getTerminalCode, reqVo.getTerminalCode()).one();
//        asStop.setStopState(YesNoEnum.yesNoEnum.ONE.getValue());
//        String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
//        asStop.setStopDate(now);
//        sfaAsStopService.updateById(asStop);
    }

    /**
     * 活动终止保存
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveAsStop(SfaAsStopReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty(reqVo.getActivityCode(), "活动编码为空");
        SfaActSchemePosApplyEntity actSchemePosApplyEntity = sfaActSchemePosApplyService
                .lambdaQuery().eq(SfaActSchemePosApplyEntity::getActivityCode, reqVo.getActivityCode()).one();
        if (null == actSchemePosApplyEntity) {
            throw new BusinessException("未查询到对应活动[" + reqVo.getActivityCode() + "]");
        }
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalName(), "终端名称为空");
        if (StringUtils.isEmpty(reqVo.getStopState())) {
            reqVo.setStopState(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        List<SfaAsStopEntity> asStopList = sfaAsStopService
                .lambdaQuery().eq(SfaAsStopEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsStopEntity::getTerminalCode, reqVo.getTerminalCode()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(asStopList)) {
            SfaAsStopEntity entity = asStopList.get(0);
            entity.setStopState(reqVo.getStopState());
            String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
            entity.setStopDate(now);
            sfaAsStopService.updateById(entity);
        } else {
            SfaAsStopEntity entity = CrmBeanUtil.copy(reqVo, SfaAsStopEntity.class);
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
            entity.setStopDate(now);
            entity.setUserName(user.getUsername());
            entity.setRealName(user.getRealname());
            entity.setPosCode(user.getPoscode());
            entity.setPosName(user.getPosname());
            entity.setOrgCode(user.getOrgcode());
            entity.setOrgName(user.getOrgname());
            sfaAsStopService.save(entity);
        }
        //查询活动协议修改状态为已终止
        sfaAsTreatyService.lambdaUpdate().eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsTreatyEntity::getTerminalCode, reqVo.getTerminalCode())
                .set(SfaAsTreatyEntity::getTreatyStatus, SfaActivityEnum.TreatyStatus.END.getVal())
                .update();
    }

    /**
     * 通过活动编码和终端编码查询执行详情
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SfaAsExecutionDetailRespVo queryExecutionDetailByActivityCodeAndTerminalCode(SfaAsExecutionDetailReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getActivityCode(), "活动编码为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        SfaAsExecutionDetailRespVo respVo = new SfaAsExecutionDetailRespVo();

        //查询活动申请
        SfaActSchemePosApplyRespVo actSchemePosApply = sfaActSchemePosApplyService
                .queryExecutionDetailByActivityCodeAndTerminalCode(reqVo.getActivityCode(), reqVo.getTerminalCode());
        respVo.setActSchemePosApply(actSchemePosApply);

        //查询执行列表
        List<SfaAsExecutionEntity> asExecutionEntities = null;
        if (StringUtils.isEmpty(reqVo.getVisitPlanInfoId())) {
            asExecutionEntities = this.lambdaQuery()
                    .eq(SfaAsExecutionEntity::getActivityCode, reqVo.getActivityCode())
                    .eq(SfaAsExecutionEntity::getTerminalCode, reqVo.getTerminalCode()).list();
        } else {
            asExecutionEntities = this.lambdaQuery()
                    .eq(SfaAsExecutionEntity::getActivityCode, reqVo.getActivityCode())
                    .eq(SfaAsExecutionEntity::getTerminalCode, reqVo.getTerminalCode())
                    .eq(SfaAsExecutionEntity::getVisitPlanInfoId, reqVo.getVisitPlanInfoId())
                    .list();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(asExecutionEntities)) {
            Map<String, String> displayTypeMap = actSchemePosApply.getDisplayTypeMap();

            List<SfaAsExecutionRespVo> asExecutionList = CrmBeanUtil.copyList(asExecutionEntities, SfaAsExecutionRespVo.class);
            List<String> executionIds = new ArrayList<>();
            for (SfaAsExecutionRespVo asExecution : asExecutionList) {
                executionIds.add(asExecution.getId());
            }
            Map<String, List<SfaAsExecutionPictureRespVo>> mapAsExecutionPicture = new HashMap<>();
            List<SfaAsExecutionPictureEntity> asExecutionPictures = sfaAsExecutionPictureService
                    .lambdaQuery().in(SfaAsExecutionPictureEntity::getExecutionId, executionIds).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asExecutionPictures)) {
                List<SfaAsExecutionPictureRespVo> asExecutionPictureList = CrmBeanUtil.copyList(asExecutionPictures, SfaAsExecutionPictureRespVo.class);
                asExecutionPictureList.forEach(o -> {
                    //图片陈列类型处理
                    o.setDisplayTypeDesc(displayTypeMap.get(o.getDisplayType()));
                });
                mapAsExecutionPicture = asExecutionPictureList.stream().collect(Collectors.groupingBy(SfaAsExecutionPictureRespVo::getExecutionId));
            }
            Map<String, List<SfaAsExecutionProductRespVo>> mapAsExecutionProduct = new HashMap<>();
            List<SfaAsExecutionProductEntity> asExecutionProducts = sfaAsExecutionProductService
                    .lambdaQuery().in(SfaAsExecutionProductEntity::getExecutionId, executionIds)
                    .eq(SfaAsExecutionProductEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asExecutionProducts)) {
                List<SfaAsExecutionProductRespVo> asExecutionProductList = CrmBeanUtil.copyList(asExecutionProducts, SfaAsExecutionProductRespVo.class);
                mapAsExecutionProduct = asExecutionProductList.stream().collect(Collectors.groupingBy(SfaAsExecutionProductRespVo::getExecutionId));
            }
            for (SfaAsExecutionRespVo asExecution : asExecutionList) {
                String executionId = asExecution.getId();
                //图片处理
                List<SfaAsExecutionPictureRespVo> asExecutionPictureRespVos = mapAsExecutionPicture.get(executionId);
                Map<String, List<SfaAsExecutionPictureRespVo>> listMap = asExecutionPictureRespVos.stream()
                        .collect(Collectors.groupingBy(SfaAsExecutionPictureRespVo::getDisplayType));
                List<SfaAsExecutionPictureTopVo> pictureTopVos = Lists.newArrayList();
                listMap.forEach((k, v) -> {
                    SfaAsExecutionPictureRespVo pictureRespVo = v.get(0);
                    SfaAsExecutionPictureTopVo pictureTopVo = new SfaAsExecutionPictureTopVo();
                    pictureTopVo.setDisplayType(k);
                    pictureTopVo.setDisplayTypeDesc(pictureRespVo.getDisplayTypeDesc());
                    pictureTopVo.setExecutionId(pictureRespVo.getExecutionId());
                    pictureTopVo.setPictureRespVos(v);
                    pictureTopVos.add(pictureTopVo);
                });
                asExecution.setAsExecutionPictureTopVos(pictureTopVos);
                //执行商品
                List<SfaAsExecutionProductTopVo> productTopVos = Lists.newArrayList();
                List<SfaAsExecutionProductRespVo> executionProductRespVos = mapAsExecutionProduct.get(executionId);
                Map<String, List<SfaAsExecutionProductRespVo>> listProMap = executionProductRespVos.stream()
                        .collect(Collectors.groupingBy(SfaAsExecutionProductRespVo::getSetmealId));
                listProMap.forEach((k, v) -> {
                    SfaAsExecutionProductRespVo productRespVo = v.get(0);
                    SfaAsExecutionProductTopVo productTopVo = new SfaAsExecutionProductTopVo();
                    productTopVo.setExecutionId(productRespVo.getExecutionId());
                    productTopVo.setSetmealId(productRespVo.getSetmealId());
                    productTopVo.setProductRespVos(v);
                    productTopVos.add(productTopVo);
                });
                asExecution.setAsExecutionProductTopVos(productTopVos);
                //处理执行所选陈列描述
                List<String> displayTypeList = Arrays.asList(asExecution.getDisplayType().split(","));
                List<String> displayTypeDescList = new ArrayList<>();
                for (String displayType : displayTypeList) {
                    String s = displayTypeMap.get(displayType);
                    if (StringUtils.isNotEmpty(s)) {
                        displayTypeDescList.add(s);
                    }
                }
                String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
                asExecution.setDisplayTypeDesc(displayTypeDesc);
            }
            respVo.setAsExecutionList(asExecutionList);
        }

        SfaAsTreatyEntity asTreatyEntity = sfaAsTreatyService.lambdaQuery()
                .eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsTreatyEntity::getTerminalCode, reqVo.getTerminalCode()).one();
        if (null != asTreatyEntity) {
            SfaAsTreatyRespVo asTreaty = CrmBeanUtil.copy(asTreatyEntity, SfaAsTreatyRespVo.class);
            /*List<SfaAsTreatyConvertProductEntity> asTreatyConvertProductEntities = sfaAsTreatyConvertProductService.lambdaQuery()
                    .eq(SfaAsTreatyConvertProductEntity::getTreatyId,asTreaty.getId()).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asTreatyConvertProductEntities)){
                List<SfaAsTreatyConvertProductRespVo> asTreatyConvertProductList =  CrmBeanUtil.copyList(asTreatyConvertProductEntities,SfaAsTreatyConvertProductRespVo.class);
                asTreaty.setAsTreatyConvertProductList(asTreatyConvertProductList);
            }
            List<SfaAsTreatyDisplayProductEntity> asTreatyDisplayProductEntities = sfaAsTreatyDisplayProductService.lambdaQuery()
                    .eq(SfaAsTreatyDisplayProductEntity::getTreatyId,asTreaty.getId()).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asTreatyDisplayProductEntities)){
                List<SfaAsTreatyDisplayProductRespVo> asTreatyDisplayProductList =  CrmBeanUtil.copyList(asTreatyDisplayProductEntities,SfaAsTreatyDisplayProductRespVo.class);
                asTreaty.setAsTreatyDisplayProductList(asTreatyDisplayProductList);
            }
            SfaAsTreatySignEntity asTreatySignEntity = sfaAsTreatySignService.lambdaQuery()
                    .eq(SfaAsTreatySignEntity::getTreatyId,asTreaty.getId()).one();
            if (null !=asTreatySignEntity){
                SfaAsTreatySignRespVo asTreatySign = CrmBeanUtil.copy(asTreatySignEntity,SfaAsTreatySignRespVo.class);
                asTreaty.setAsTreatySign(asTreatySign);
            }*/
            respVo.setAsTreaty(asTreaty);
        }

        SfaAsCashingEntity asCashingEntity = sfaAsCashingService.lambdaQuery()
                .eq(SfaAsCashingEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsCashingEntity::getTerminalCode, reqVo.getTerminalCode()).one();
        if (null != asCashingEntity) {
            SfaAsCashingRespVo asCashing = CrmBeanUtil.copy(asCashingEntity, SfaAsCashingRespVo.class);

            List<SfaAsCashingProductEntity> asCashingProductEntities = sfaAsCashingProductService.lambdaQuery()
                    .eq(SfaAsCashingProductEntity::getCashingId, asCashing.getId()).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asCashingProductEntities)) {
                List<SfaAsCashingProductRespVo> asCashingProductList = CrmBeanUtil.copyList(asCashingProductEntities, SfaAsCashingProductRespVo.class);
                asCashing.setAsCashingProductList(asCashingProductList);
            }

            List<SfaAsCashingPictureEntity> asCashingPictureEntities = sfaAsCashingPictureService.lambdaQuery()
                    .eq(SfaAsCashingPictureEntity::getCashingId, asCashing.getId()).list();
            if (CollectionUtil.listNotEmptyNotSizeZero(asCashingPictureEntities)) {
                List<SfaAsCashingPictureRespVo> asCashingPictureList = CrmBeanUtil.copyList(asCashingPictureEntities, SfaAsCashingPictureRespVo.class);
                asCashing.setAsCashingPictureList(asCashingPictureList);
            }
            respVo.setAsCashing(asCashing);
        }

        SfaAsStopEntity asStopEntity = sfaAsStopService.lambdaQuery()
                .eq(SfaAsStopEntity::getActivityCode, reqVo.getActivityCode())
                .eq(SfaAsStopEntity::getTerminalCode, reqVo.getTerminalCode()).one();
        if (null != asStopEntity) {
            SfaAsStopRespVo asStop = CrmBeanUtil.copy(asStopEntity, SfaAsStopRespVo.class);
            //判断是否存在对付数据
            if (!ObjectUtils.isEmpty(respVo.getAsCashing())) {
                //特殊处理0 未终止 未对付，1 已终止，2 已兑付 方便前端控制
                asStop.setStopState("2");
            }
            respVo.setAsStop(asStop);
            if (!ObjectUtils.isEmpty(asTreatyEntity)) {
                respVo.setParticipateInType(SfaActivityEnum.participateInType.A.getVal());
            } else {
                respVo.setParticipateInType(SfaActivityEnum.participateInType.F.getVal());
            }
        }
        return respVo;
    }

    /**
     * 订单修改商品同步修改活动执行商品信息
     *
     * @param params
     */
    @Override
    public void updateExecutionProduct(SfaAsExecuteOrderProductReqVo params) {
        String executeId = params.getExecuteId();
        //删除原执行商品信息
        sfaAsExecutionProductService.lambdaUpdate().eq(SfaAsExecutionProductEntity::getExecutionId, executeId)
                .set(SfaAsExecutionProductEntity::getDelFlag, CrmDelFlagEnum.DELETE.getCode())
                .update();
        //新增新商品信息
        List<SfaAsExecutionProductEntity> productEntities = Lists.newArrayList();
        params.getSfaActSchemeSetmealRespVos().forEach(o -> {
            //本品
            List<SfaActSchemeProductRespVo> bp = o.getBpSchemeProductList();
            bp.forEach(b -> {
                SfaAsExecutionProductEntity entity = new SfaAsExecutionProductEntity();
                entity.setExecutionId(executeId);
                entity.setItmeType(b.getItmeType());
                if (StringUtils.isNotEmpty(b.getPrice())) {
                    //价格有可能为空
                    entity.setPrice(new BigDecimal(b.getPrice()));
                }
                entity.setProductCode(b.getProductCode());
                entity.setProductName(b.getProductName());
                entity.setProductNum(b.getQuantity().toBigInteger());
                entity.setSetmealId(b.getSetmealId());
                productEntities.add(entity);
            });
            //赠品
            List<SfaActSchemeProductRespVo> zp = o.getZpSchemeProductList();
            zp.forEach(z -> {
                SfaAsExecutionProductEntity entity = new SfaAsExecutionProductEntity();
                entity.setExecutionId(executeId);
                entity.setItmeType(z.getItmeType());
                if (StringUtils.isNotEmpty(z.getPrice())) {
                    // //价格有可能为空
                    entity.setPrice(new BigDecimal(z.getPrice()));
                }
                entity.setProductCode(z.getProductCode());
                entity.setProductName(z.getProductName());
                entity.setProductNum(z.getQuantity().toBigInteger());
                entity.setSetmealId(z.getSetmealId());
                productEntities.add(entity);
            });
        });
        sfaAsExecutionProductService.saveBatch(productEntities);
    }

    /**
     * 通过门店编码和拜访ID查询方案活动
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<SfaActSchemePosApplyRespVo> findActSchemeByVisitPlanInfoId(SfaAsExecutionDetailReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getVisitPlanInfoId(), "拜访ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        //查询执行列表
        List<SfaAsExecutionEntity> asExecutionEntities = this.lambdaQuery()
                .eq(SfaAsExecutionEntity::getTerminalCode, reqVo.getTerminalCode())
                .eq(SfaAsExecutionEntity::getVisitPlanInfoId, reqVo.getVisitPlanInfoId())
                .list();
        if (CollectionUtil.listEmpty(asExecutionEntities)) {
            return new ArrayList<>();
        }
        Set<String> activityCodes = asExecutionEntities.stream()
                .map(SfaAsExecutionEntity::getActivityCode).collect(Collectors.toSet());
        List<SfaActSchemePosApplyEntity> schemePosApplyEntities = sfaActSchemePosApplyService.lambdaQuery()
                .in(SfaActSchemePosApplyEntity::getActivityCode, activityCodes).list();
        return CrmBeanUtil.copyList(schemePosApplyEntities, SfaActSchemePosApplyRespVo.class);
    }
}
