package com.biz.crm.asexecution.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.asexecution.mapper.SfaAsTreatyMapper;
import com.biz.crm.asexecution.model.SfaAsTreatyConvertProductEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyDisplayProductEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.model.SfaAsTreatySignEntity;
import com.biz.crm.asexecution.service.ISfaAsTreatyConvertProductService;
import com.biz.crm.asexecution.service.ISfaAsTreatyDisplayProductService;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.asexecution.service.ISfaAsTreatySignService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.*;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.CashTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.DisplayTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.GoodsTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.SfaTpmActTreatyRedisVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailExecuteRespVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.nebular.upload.vo.WordTemplateDataVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.upload.file.OfficeFileFeign;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstepbase.VisitBaseCheck;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.cglib.beans.BeanMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 方案活动协议;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaAsTreatyServiceExpandImpl")
@Transactional
public class SfaAsTreatyServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaAsTreatyMapper, SfaAsTreatyEntity> implements ISfaAsTreatyService {

    @Resource
    private SfaAsTreatyMapper sfaAsTreatyMapper;
    @Autowired
    private ISfaAsTreatyConvertProductService sfaAsTreatyConvertProductService;
    @Autowired
    private ISfaAsTreatyDisplayProductService sfaAsTreatyDisplayProductService;
    @Autowired
    private ISfaAsTreatySignService sfaAsTreatySignService;
    @Resource
    private OfficeFileFeign officeFileFeign;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Resource
    private RedisService redisService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmUserFeign mdmUserFeign;
    @Autowired
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Autowired
    private ISfaTpmActDetailService sfaTpmActDetailService;
    @Autowired
    private ISfaTpmActDetailExecuteService sfaTpmActDetailExecuteService;

    /**
     * 活动协议报表
     *
     * @param params
     * @return
     */
    @Override
    public PageResult<SfaAsTreatyRespVo> report(SfaAsTreatyReqVo params) {
        Page<SfaAsTreatyRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<SfaAsTreatyRespVo> list = sfaAsTreatyMapper.report(page, params);
        //数据处理
        list.forEach(o -> {
            o.setUrlPath(o.getUrlPathPrefix() + o.getUrlPath());
            o.setTreatyStatusDesc(SfaActivityEnum.TreatyStatus.GETMAP.get(o.getTreatyStatus()));
        });
        return PageResult.<SfaAsTreatyRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 工作台-货品协议保存
     *
     * @param vo
     */
    @Override
    public String saveWorkBenchGoodsTreaty(GoodsTreatyVo vo) {
        this.checkDisplayTreaty(vo);
        AssertUtils.isNotEmpty(vo.getPayGoodList(), "支付货品为空");
        AssertUtils.isNotEmpty(vo.getRewardGoodList(), "奖励货品为空");
        //进行短信验证
        this.visitBaseComponent.textCheck(vo);
        //总价格
        BigDecimal totalPrice = this.checkGoodTreatyProduct(vo);
        SfaAsTreatyEntity entity = CrmBeanUtil.copy(vo, SfaAsTreatyEntity.class);
        //设置客户类型
        entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        if (StringUtils.isNotEmpty(vo.getVisitPlanInfoId())) {
            SfaAsTreatyEntity oldTreatyEntity = this.lambdaQuery()
                    .eq(SfaAsTreatyEntity::getVisitPlanInfoId, vo.getVisitPlanInfoId())
                    .eq(SfaAsTreatyEntity::getActivityCode, vo.getActivityCode()).one();
            if (null != oldTreatyEntity) {
                entity.setId(oldTreatyEntity.getId());
            }
        }
        entity.setTreatySource(SfaCommonEnum.actTreatySource.TPM_ACTIVITY.getValue());
        entity.setTreatyCode(CodeUtil.generateCode(SfaCodeEnum.schemeCode.SCHEME_ACTIVITY_TREATY_CODE.getVal()));
        entity.setTreatyStatus(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal());
        entity.setTotalPrice(totalPrice);
        //进行金额校验
        visitBaseComponent.checkTpmActTreatyAmount(vo.getActivityCode(), totalPrice);
        this.saveOrUpdate(entity);
        vo.setId(entity.getId());
        //先进行货品的删除
        this.sfaAsTreatyConvertProductService.remove(Wrappers.lambdaQuery(SfaAsTreatyConvertProductEntity.class)
                .eq(SfaAsTreatyConvertProductEntity::getTreatyId, entity.getId()));
        List<SfaAsTreatyConvertProductEntity> convertProductEntities = new ArrayList<>();
        vo.getPayGoodList().forEach(data -> {
            SfaAsTreatyConvertProductEntity productEntity = CrmBeanUtil.copy(data, SfaAsTreatyConvertProductEntity.class);
            productEntity.setTreatyId(entity.getId());
            productEntity.setItemType(SfaCommonEnum.actDisplayProductType.pay.getValue());
            convertProductEntities.add(productEntity);
        });
        vo.getRewardGoodList().forEach(data -> {
            SfaAsTreatyConvertProductEntity productEntity = CrmBeanUtil.copy(data, SfaAsTreatyConvertProductEntity.class);
            productEntity.setTreatyId(entity.getId());
            productEntity.setItemType(SfaCommonEnum.actDisplayProductType.reward.getValue());
            convertProductEntities.add(productEntity);
        });
        this.sfaAsTreatyConvertProductService.saveBatch(convertProductEntities);
        //进行陈列商品保存
        this.saveDisplayProduct(vo.getDisplayProductList(), entity.getId());
        //进行签名照拍照
        this.saveSignPic(vo.getSignPic(), entity.getId());

        SfaTpmActTreatyRedisVo redisVo = CrmBeanUtil.copy(vo, SfaTpmActTreatyRedisVo.class);
        //进行pdf上传
        this.createPdf(redisVo, entity, SfaActivityEnum.paymentMethod.HW.getVal(), convertProductEntities);
        //放置到redis缓存
        String pdfUrlPath = entity.getUrlPathPrefix() + entity.getUrlPath();
        this.redisService.hmset(SfaTpmActTreatyRedisVo.getRedisHashKey(entity.getId()), SfaTpmActTreatyRedisVo.buildMap(entity.getId(), pdfUrlPath), SfaTpmActTreatyRedisVo.REDIS_EXPIRE_TIME);
        //进行业务动态保存
        entity.setId(entity.getActivityCode());
        visitBaseComponent.tpmDoListener(entity);
        //保存活动执行终端数据
        saveTpmActExecute(vo.getTerminalCode(),vo.getActivityCode());
        return entity.getId();
    }

    /**
     * 工作台-现金协议保存
     *
     * @param vo
     */
    @Override
    public String saveWorkBenchCashTreaty(CashTreatyVo vo) {
        this.checkDisplayTreaty(vo);
        if (vo.getMonthPayAmount() == null) {
            throw new BusinessException("每月支付现金为空");
        }
        if (vo.getTotalAmount() == null) {
            throw new BusinessException("合计奖励现金为空");
        }
        AssertUtils.isNotEmpty(vo.getPayee(), "奖励收款人为空");
        AssertUtils.isNotEmpty(vo.getContactPhone(), "联系电话为空");
        AssertUtils.isNotEmpty(vo.getRemarks(), "附加条件说明为空");
        //进行短信验证
        this.visitBaseComponent.textCheck(vo);
        SfaAsTreatyEntity entity = CrmBeanUtil.copy(vo, SfaAsTreatyEntity.class);
        //设置客户类型
        entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        if (StringUtils.isNotEmpty(vo.getVisitPlanInfoId())) {
            SfaAsTreatyEntity oldTreatyEntity = this.lambdaQuery()
                    .eq(SfaAsTreatyEntity::getVisitPlanInfoId, vo.getVisitPlanInfoId())
                    .eq(SfaAsTreatyEntity::getActivityCode, vo.getActivityCode()).one();
            if (null != oldTreatyEntity) {
                entity.setId(oldTreatyEntity.getId());
            }
        }
        entity.setTotalPrice(entity.getTotalAmount());
        //进行金额校验
        visitBaseComponent.checkTpmActTreatyAmount(vo.getActivityCode(), entity.getTotalPrice());
        entity.setTreatySource(SfaCommonEnum.actTreatySource.TPM_ACTIVITY.getValue());
        entity.setTreatyCode(CodeUtil.generateCode(SfaCodeEnum.schemeCode.SCHEME_ACTIVITY_TREATY_CODE.getVal()));
        entity.setTreatyStatus(SfaActivityEnum.TreatyStatus.IN_EXECUTION.getVal());
        this.saveOrUpdate(entity);
        vo.setId(entity.getId());
        //进行陈列商品保存
        this.saveDisplayProduct(vo.getDisplayProductList(), entity.getId());
        //进行签名照拍照
        this.saveSignPic(vo.getSignPic(), entity.getId());
        SfaTpmActTreatyRedisVo redisVo = CrmBeanUtil.copy(vo, SfaTpmActTreatyRedisVo.class);
        //进行pdf上传
        this.createPdf(redisVo, entity, SfaActivityEnum.paymentMethod.XJ.getVal(), null);
        //放置到redis缓存
        String pdfUrlPath = entity.getUrlPathPrefix() + entity.getUrlPath();
        this.redisService.hmset(SfaTpmActTreatyRedisVo.getRedisHashKey(entity.getId()), SfaTpmActTreatyRedisVo.buildMap(entity.getId(), pdfUrlPath), SfaTpmActTreatyRedisVo.REDIS_EXPIRE_TIME);
        //进行业务动态数据保存
        entity.setId(entity.getActivityCode());
        visitBaseComponent.tpmDoListener(entity);
        //保存活动执行终端数据
        saveTpmActExecute(vo.getTerminalCode(),vo.getActivityCode());
        return entity.getId();
    }


    public void saveTpmActExecute(String clientCode,String actDetailCode){
        //保存活动执行数据
        SfaTpmActDetailExecuteRespVo executeRespVo = new SfaTpmActDetailExecuteRespVo();
        executeRespVo.setTerminalCode(clientCode);
        executeRespVo.setActDetailCode(actDetailCode);
        sfaTpmActDetailExecuteService.saveTpmActExecute(executeRespVo);
    }

    /**
     * 拜访步骤-tpm活动-货品协议签署
     *
     * @param vo
     */
    @Override
    public String saveVisitStepGoodsTreaty(VisitBaseVo<GoodsTreatyVo> vo) {
        //基础数据校验
        VisitBaseCheck.checkBaseData(vo);
        GoodsTreatyVo goodsTreatyVo = vo.getStepExecuteData();
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        goodsTreatyVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        goodsTreatyVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = visitBaseComponent.getFormData(vo.getFormId(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, goodsTreatyVo.getLongitude(), goodsTreatyVo.getLatitude());
        //状态更新
        visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        //进行数据保存
        return this.saveWorkBenchGoodsTreaty(goodsTreatyVo);
    }

    /**
     * 拜访步骤-tpm活动-现金协议签署
     *
     * @param vo
     */
    @Override
    public String saveVisitStepCashTreaty(VisitBaseVo<CashTreatyVo> vo) {
        //基础数据校验
        VisitBaseCheck.checkBaseData(vo);
        CashTreatyVo cashTreatyVo = vo.getStepExecuteData();
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        cashTreatyVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        cashTreatyVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = visitBaseComponent.getFormData(vo.getFormId(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, cashTreatyVo.getLongitude(), cashTreatyVo.getLatitude());
        //状态更新
        visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        //进行数据保存
        return this.saveWorkBenchCashTreaty(cashTreatyVo);
    }

    /**
     * 查询tpm活动-陈列协议
     *
     * @param id
     * @return
     */
    @Override
    public String loadTpmActTreatyDetail(String id) {
        Object obj = this.redisService.hmget(SfaTpmActTreatyRedisVo.getRedisHashKey(id), id);
        String pdfUrlPath = null;
        if (obj == null) {
            SfaAsTreatyEntity treatyEntity = this.lambdaQuery()
                    .eq(SfaAsTreatyEntity::getId, id).one();
            if (treatyEntity == null) {
                throw new BusinessException("主键id错误,未查询到相关的陈列协议信息");
            }
            pdfUrlPath = treatyEntity.getUrlPathPrefix() + treatyEntity.getUrlPath();
            this.redisService.hmset(SfaTpmActTreatyRedisVo.getRedisHashKey(id), SfaTpmActTreatyRedisVo.buildMap(id, pdfUrlPath), SfaTpmActTreatyRedisVo.REDIS_EXPIRE_TIME);
        } else {
            pdfUrlPath = (String) obj;
        }
        return pdfUrlPath;
    }

    /**
     * 基础信息验证
     *
     * @param vo
     */
    protected void checkDisplayTreaty(DisplayTreatyVo vo) {
        AssertUtils.isNotEmpty(vo.getDealerCode(), "经销商编码不能为空");
        AssertUtils.isNotEmpty(vo.getDealerName(), "经销商名称不能为空");
        AssertUtils.isNotEmpty(vo.getActivityCode(), "活动编码不能为空");
        AssertUtils.isNotEmpty(vo.getDisplayBrand(), "陈列品牌不能为空");
        AssertUtils.isNotEmpty(vo.getDisplayItem(), "陈列品项不能为空");
        AssertUtils.isNotEmpty(vo.getDisplayPlace(), "陈列位置为空");
        AssertUtils.isNotEmpty(vo.getDisplaySpecs(), "陈列规格为空");
        AssertUtils.isNotEmpty(vo.getDisplayNumber(), "陈列件数为空");
        AssertUtils.isNotEmpty(vo.getDisplayStartTime(), "陈列开始时间为空");
        AssertUtils.isNotEmpty(vo.getDisplayEndTime(), "陈列结束时间为空");
        AssertUtils.isNotEmpty(vo.getDisplayMonth(), "陈列月份为空");
        AssertUtils.isNotEmpty(vo.getTerminalCode(), "终端编码为空");
        AssertUtils.isNotEmpty(vo.getTerminalName(), "终端名称为空");

        if (null == vo.getSignPic() && null == vo.getLineStatus()) {
            throw new BusinessException("签名照为空");
        }
        SfaAsTreatyEntity entity = this.lambdaQuery()
                .eq(SfaAsTreatyEntity::getActivityCode, vo.getActivityCode())
                .eq(SfaAsTreatyEntity::getTerminalCode, vo.getTerminalCode()).one();
        if (null != entity) {
            throw new BusinessException("该活动已签署tpm活动陈列协议,不可在进行签署");
        }
    }

    /**
     * 陈列协议-货品协议 货品校验
     *
     * @param vo
     */
    protected BigDecimal checkGoodTreatyProduct(GoodsTreatyVo vo) {
        SfaTpmActDetailEntity actDetailEntity = sfaTpmActDetailService.lambdaQuery()
                .eq(SfaTpmActDetailEntity::getActDetailCode, vo.getActivityCode())
                .select(SfaTpmActDetailEntity::getHdCommitment).one();
        BigDecimal price = BigDecimal.ZERO;
        vo.getPayGoodList().forEach(data -> {
            AssertUtils.isNotEmpty(data.getProductCode(), "支付货品产品编码为空");
            AssertUtils.isNotEmpty(data.getProductName(), "支付货品产品名称为空");
            if (data.getProductNum() == null) {
                throw new BusinessException("支付货品" + data.getProductName() + "数量为空");
            }
        });
        for (GoodsTreatyVo.ConvertProduct data : vo.getRewardGoodList()) {
            AssertUtils.isNotEmpty(data.getProductCode(), "奖励货品产品编码为空");
            AssertUtils.isNotEmpty(data.getProductName(), "奖励货品产品名称为空");
            if (data.getProductNum() == null) {
                throw new BusinessException("奖励货品" + data.getProductName() + "数量为空");
            }
            if (data.getPrice() == null) {
                throw new BusinessException("奖励货品" + data.getProductName() + "价格为空");
            }
            if (actDetailEntity != null && actDetailEntity.getHdCommitment() != null) {
                price = price.add(actDetailEntity.getHdCommitment().multiply(new BigDecimal(data.getProductNum())));
            } else {
                price = price.add(data.getPrice().multiply(new BigDecimal(data.getProductNum())));
            }
        }
        return price;
    }

    /**
     * 保存陈列产品
     *
     * @param displayProductList
     */
    protected void saveDisplayProduct(List<DisplayTreatyVo.DisplayProduct> displayProductList, String treatyId) {
        //先进性删除陈列产品
        this.sfaAsTreatyDisplayProductService.remove(Wrappers.lambdaQuery(SfaAsTreatyDisplayProductEntity.class)
                .eq(SfaAsTreatyDisplayProductEntity::getTreatyId, treatyId));

        if (CollectionUtil.listNotEmptyNotSizeZero(displayProductList)) {
            List<SfaAsTreatyDisplayProductEntity> displayProductEntityList = new ArrayList<>();
            displayProductList.forEach(data -> {
                SfaAsTreatyDisplayProductEntity entity = CrmBeanUtil.copy(data, SfaAsTreatyDisplayProductEntity.class);
                entity.setTreatyId(treatyId);
                displayProductEntityList.add(entity);
            });
            this.sfaAsTreatyDisplayProductService.saveBatch(displayProductEntityList);
        }
    }

    /**
     * 保存签名照
     *
     * @param signPic
     * @param treatyId
     */
    protected void saveSignPic(DisplayTreatyVo.SignPic signPic, String treatyId) {
        //先进行删除
        this.sfaAsTreatySignService.remove(Wrappers.lambdaQuery(SfaAsTreatySignEntity.class)
                .eq(SfaAsTreatySignEntity::getTreatyId, treatyId));

        SfaAsTreatySignEntity signEntity = CrmBeanUtil.copy(signPic, SfaAsTreatySignEntity.class);
        signEntity.setTreatyId(treatyId);
        this.sfaAsTreatySignService.save(signEntity);
    }


    /**
     * pdf协议生成
     *
     * @param reqVo
     * @param entity
     */
    private void createPdf(SfaTpmActTreatyRedisVo reqVo, SfaAsTreatyEntity entity, String type, List<SfaAsTreatyConvertProductEntity> convertProductEntities) {
        Map<String, String> actProductMap = sfaTpmActDetailProductService.lambdaQuery()
                .eq(SfaTpmActDetailProductEntity::getActDetailCode, entity.getActivityCode())
                .list().stream().filter(data -> StringUtils.isNotEmpty(data.getSpec()))
                .collect(Collectors.toMap(SfaTpmActDetailProductEntity::getProductCode, SfaTpmActDetailProductEntity::getSpec));
        DisplayTreatyVo.SignPic asTreatySign = reqVo.getSignPic();
        TemplateTreatyVo templateTreatyVo = CrmBeanUtil.copy(reqVo, TemplateTreatyVo.class);
        Result<MdmTerminalVo> terminalResult = mdmTerminalFeign.query(null, reqVo.getTerminalCode());
        if (null != terminalResult && terminalResult.isSuccess() && terminalResult.getResult() != null) {
            MdmTerminalVo terminalVo = terminalResult.getResult();
            templateTreatyVo.setTerminalAddr(terminalVo.getTerminalAddress());
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalVo.getContacts())) {
                MdmTerminalContactVo contacts = terminalVo.getContacts().get(0);
                templateTreatyVo.setTerminalPhone(contacts.getContactPhone());
            }
        } else {
            throw new BusinessException("未查询到终端信息");
        }
        templateTreatyVo.setRemarks(StringUtils.isEmpty(templateTreatyVo.getRemarks()) ? "无" : templateTreatyVo.getRemarks());
        //当前登录人
        UserRedis userRedis = UserUtils.getUser();
        Result<MdmUserRespVo> userRespVoResult = mdmUserFeign.query(new MdmUserReqVo() {{
            this.setUserName(userRedis.getUsername());
        }});
        MdmUserRespVo userRespVo = ApiResultUtil.objResult(userRespVoResult, userRespVoResult.isSuccess());
        if (StringUtils.isNotEmpty(userRespVo.getUserPhone())) {
            templateTreatyVo.setCurrUserPhone(userRespVo.getUserPhone());
        }
        String currUserName = formatStrLength(userRedis.getRealname(), 10);
        String currUserPhone = templateTreatyVo.getCurrUserPhone();
        currUserPhone = currUserPhone + "&#160;&#160;&#160;&#160;&#160;&#160;";
        templateTreatyVo.setCurrUserPhone(currUserPhone);
        templateTreatyVo.setCurrUserName(currUserName);
        //陈列产品处理
        if (StringUtils.isEmpty(reqVo.getDisplayItem())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayBrand());
        } else if (CollectionUtil.listEmpty(reqVo.getDisplayProductList())) {
            templateTreatyVo.setDisplayInfo(reqVo.getDisplayItem());
        } else if (CollectionUtil.listNotEmpty(reqVo.getDisplayProductList())) {
            List<String> productNames = Lists.newArrayList();
            reqVo.getDisplayProductList().forEach(o -> {
                productNames.add(o.getProductName());
            });
            String displayInfo = Joiner.on("、").join(productNames);
            templateTreatyVo.setDisplayInfo(displayInfo);
        }
        //转换为Map
        Map<String, Object> dataMap = Maps.newHashMap();
        if (templateTreatyVo != null) {
            BeanMap beanMap = BeanMap.create(templateTreatyVo);
            for (Object key : beanMap.keySet()) {
                dataMap.put(key.toString(), beanMap.get(key));
            }
        }
        //时间处理 年 /月 /日
        String[] startTime = reqVo.getDisplayStartTime().split("-");
        String[] endTime = reqVo.getDisplayEndTime().split("-");
        dataMap.put("startYear", startTime[0]);
        dataMap.put("startMonth", startTime[1]);
        dataMap.put("startDay", startTime[2]);
        dataMap.put("endYear", endTime[0]);
        dataMap.put("endMonth", endTime[1]);
        dataMap.put("endDay", endTime[2]);
        //当前时间
        String date2Str = DateUtil.date2Str(DateUtil.date_sdf_wz);
        dataMap.put("currDate", date2Str);
        boolean equals = SfaActivityEnum.paymentMethod.XJ.getVal().equals(type);
        //商品处理
        if (!equals) {
            Map<String, List<SfaAsTreatyConvertProductEntity>> listMap = convertProductEntities.stream()
                    .collect(Collectors.groupingBy(SfaAsTreatyConvertProductEntity::getItemType));
            listMap.forEach((k, v) -> {
                List<TemplateTreatyProductVo> productVos = v.stream().map(pd -> {
                    TemplateTreatyProductVo templateTreatyProductVo = CrmBeanUtil.copy(pd, TemplateTreatyProductVo.class);
                    if (actProductMap != null && actProductMap.size() > 0 && actProductMap.containsKey(pd.getProductCode())) {
                        templateTreatyProductVo.setSpec(actProductMap.get(pd.getProductCode()));
                    } else {
                        templateTreatyProductVo.setSpec("无");
                    }
                    return templateTreatyProductVo;
                }).collect(Collectors.toList());
                if (SfaActivityEnum.bpItemType.bp.getVal().equals(k)) {
                    dataMap.put("products", productVos);
                } else {
                    dataMap.put("gifts", productVos);
                }
            });
        }
        if (!dataMap.containsKey("gifts") || dataMap.get("gifts") == null) {
            dataMap.put("gifts", new ArrayList<>());
        } else {
            List<TemplateTreatyProductVo> temp = (List<TemplateTreatyProductVo>) dataMap.get("gifts");
            if (CollectionUtil.listNotEmptyNotSizeZero(temp)) {
                dataMap.put("gifts", temp);
            }
        }
        WordTemplateDataVo dataVo = new WordTemplateDataVo();
        dataVo.setLeftOffset(340);
        dataVo.setTopOffset(equals ? -10 : -20);
        dataVo.setTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getVal() : SfaActivityEnum.TemplateType.PRODUCT.getVal());
        dataVo.setZipTemplateName(equals ? SfaActivityEnum.TemplateType.MONEY.getDesc() : SfaActivityEnum.TemplateType.PRODUCT.getDesc());
        dataVo.setFileName(entity.getTreatyCode());
        dataVo.setTabText("代表（签字）");
        dataVo.setSginImageUrl(asTreatySign.getUrlPathPrefix() + asTreatySign.getUrlPath());
        dataVo.setDataMap(dataMap);
        Result<List<UploadVo>> uploadResult = officeFileFeign.createWordDocxToPdfFile(dataVo);
        List<UploadVo> uploadVos = null;
        if (uploadResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero(uploadResult.getResult())) {
            uploadVos = ApiResultUtil.objResult(uploadResult, true);
        } else {
            throw new BusinessException("生成PDF文件失败");
        }
        if (!CollectionUtils.isEmpty(uploadVos)) {
            UploadVo uploadVo = uploadVos.get(0);
            entity.setObjectName(uploadVo.getObjectName());
            entity.setUrlPath(uploadVo.getUrlPath());
            entity.setUrlPathPrefix(uploadVo.getUrlPathPrefix());
            this.updateById(entity);
        }
    }

    private String formatStrLength(String str, int len) {
        //总长度
        int length = str.length();
        for (int i = 0, j = len - length; i < j; i++) {
            str = str + "&#160;";
        }
        return str;
    }
}
