package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 拜访（异常提报） 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_abnormal")
@CrmTable(name = "sfa_visit_step_abnormal", tableNote = "拜访（异常提报）",indexes = {
        @Index(name = "visit_step_abnormal_index1",columnList = "client_id"),
        @Index(name = "visit_step_abnormal_index2",columnList = "client_code")
})
public class SfaVisitStepAbnormalEntity extends CrmExtTenEntity<SfaVisitStepAbnormalEntity> {

    /**
     * 网点id
     */
    @CrmColumn(name = "client_id", length = 40, note = "网点id")
    private String clientId;

    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 异常描述
     */
    @CrmColumn(name = "abnormal_causes", length = 512, note = "异常描述")
    private String abnormalCauses;

}
