package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 工作总结 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary")
@CrmTable(name = "sfa_work_summary", tableNote = "工作总结")
public class SfaWorkSummaryEntity extends CrmExtTenEntity<SfaWorkSummaryEntity> {

    /**
     * 总结类型
     */
    @CrmColumn(name = "summary_type", length = 32, note = "总结类型")
    private String summaryType;

    /**
     * 总结内容
     */
    @CrmColumn(name = "content", length = 512, note = "总结内容")
    private String content;

    /**
     * 工作计划
     */
    @CrmColumn(name = "word_plan", length = 512, note = "工作计划")
    private String wordPlan;


}
