package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作任务(抄送) 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_task_notice")
@CrmTable(name = "sfa_work_task_notice", tableNote = "工作任务(抄送)",indexes = {
        @Index(name = "work_task_notice_index1",columnList = "notifier_code")
})
public class SfaWorkTaskNoticeEntity extends CrmExtTenEntity<SfaWorkTaskNoticeEntity> {

    /**
     * 抄送人姓名
     */
    @CrmColumn(name = "notifier_name", length = 32, note = "抄送人姓名")
    private String notifierName;

    /**
     * 抄送人账号
     */
    @CrmColumn(name = "notifier_code", length = 60, note = "抄送人账号")
    private String notifierCode;

    /**
     * 抄送人组织编码
     */
    @CrmColumn(name = "notifier_org_code", length = 32, note = "抄送人组织编码")
    private String notifierOrgCode;

    /**
     * 抄送人组织名称
     */
    @CrmColumn(name = "notifier_org_name", length = 60, note = "抄送人组织名称")
    private String notifierOrgName;

    /**
     * 抄送人职位编码
     */
    @CrmColumn(name = "notifier_pos_code", length = 32, note = "抄送人职位编码")
    private String notifierPosCode;

    /**
     * 抄送人职位名称
     */
    @CrmColumn(name = "notifier_pos_name", length = 60, note = "抄送人职位名称")
    private String notifierPosName;

    /**
     * 状态
     */
    @CrmColumn(name = "task_status", length = 32, note = "状态")
    private String taskStatus;

}
