package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作任务(接收) 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_task_receve")
@CrmTable(name = "sfa_work_task_receve", tableNote = "工作任务(接收)",indexes = {
        @Index(name = "sfa_work_task_receve_index1",columnList = "task_id"),
        @Index(name = "sfa_work_task_receve_index2",columnList = "recever_code")
})
public class SfaWorkTaskReceveEntity extends CrmExtTenEntity<SfaWorkTaskReceveEntity> {

    /**
     * 任务id
     */
    @CrmColumn(name = "task_id", length = 32, note = "任务id")
    private String taskId;

    /**
     * 接收人姓名
     */
    @CrmColumn(name = "recever_name", length = 32, note = "接收人姓名")
    private String receverName;

    /**
     * 接收人账号
     */
    @CrmColumn(name = "recever_code", length = 512, note = "接收人账号")
    private String receverCode;

    /**
     * 接收人组织编码
     */
    @CrmColumn(name = "recever_org_code", length = 512, note = "接收人组织编码")
    private String receverOrgCode;

    /**
     * 接收人组织名称
     */
    @CrmColumn(name = "recever_org_name", length = 512, note = "接收人组织名称")
    private String receverOrgName;

    /**
     * 接收人职位编码
     */
    @CrmColumn(name = "recever_pos_code", length = 512, note = "接收人职位编码")
    private String receverPosCode;

    /**
     * 接收人职位名称
     */
    @CrmColumn(name = "recever_pos_name", length = 512, note = "接收人职位名称")
    private String receverPosName;

    /**
     * 接收时间
     */
    @CrmColumn(name = "receve_date", length = 32, note = "接收时间")
    private String receveDate;

    /**
     * 执行时定位地址
     */
    @CrmColumn(name = "address", length = 512, note = "执行时定位地址")
    private String address;

    /**
     * 执行总结
     */
    @CrmColumn(name = "summary", length = 512, note = "执行总结")
    private String summary;

    /**
     * 执行状态
     */
    @CrmColumn(name = "execute_status", length = 32, note = "执行状态")
    private String executeStatus;

}
