package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作任务(发布) 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_task_release")
@CrmTable(name = "sfa_work_task_release", tableNote = "工作任务(发布)",indexes = {
        @Index(name = "sfa_work_task_release_index1",columnList = "start_date,end_date")
})
public class SfaWorkTaskReleaseEntity extends CrmExtTenEntity<SfaWorkTaskReleaseEntity> {

    /**
     * 任务标题
     */
    @CrmColumn(name = "task_title", length = 200, note = "任务标题")
    private String taskTitle;

    /**
     * 截至时间
     */
    @CrmColumn(name = "end_date", length = 32, note = "截至时间")
    private String endDate;

    /**
     * 任务内容
     */
    @CrmColumn(name = "content", length = 512, note = "任务内容")
    private String content;

    /**
     * 任务进度
     */
    @CrmColumn(name = "progress", length = 32, note = "任务进度")
    private String progress;

    /**
     * 任务状态
     */
    @CrmColumn(name = "task_status", length = 32, note = "任务状态")
    private String taskStatus;

    /**
     * 开始时间
     */
    @CrmColumn(name = "start_date", length = 32, note = "开始时间")
    private String startDate;

    /**
     * 地址
     */
    @CrmColumn(name = "task_site", length = 200, note = "地址")
    private String taskSite;

    /**
     * 任务编码
     */
    @CrmColumn(name = "task_code", length = 32, note = "任务编码")
    private String taskCode;

}
