package com.biz.crm.assistant.service;

import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReportFromReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryStaffReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryReportFromsRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;


/**
 * 工作总结 接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface ISfaWorkSummaryService extends IService<SfaWorkSummaryEntity> {


    /**
     * 列表日
     * @param sfaWorkSummaryReqVo
     * @return PageResult<SfaWorkSummaryRespVo>
     */
    SfaWorkSummaryRespVo findTaskSummary(SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 查询人员详情_天
     * @param sfaWorkSummaryStaffReqVo
     * @return
     */
    SfaWorkSummaryRespVo querySummaryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo);


    /**
     * 查询
     * @param sfaWorkSummaryReqVo
     * @return SfaWorkSummaryRespVo
     */
    SfaWorkSummaryRespVo query(SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void save(SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void update(SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 报表
     * @param reqVo
     * @return
     */
    PageResult<SfaWorkSummaryReportFromsRespVo> summaryReportFroms(SfaWorkSummaryReportFromReqVo reqVo);

    /**
     * 获取某月完成日报  默认登月
     * @param sfaWorkSummaryReqVo
     * @return
     */
    Integer getSfaWorkSummaryByCount(SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 获取某月完成日报  默认本月
     * @param sfaWorkSummaryReqVo
     * @return
     */
    Integer getSfaWorkSummaryPrimaryByCount(SfaWorkSummaryReqVo sfaWorkSummaryReqVo);


}

