package com.biz.crm.assistant.service;

import com.biz.crm.assistant.model.SfaWorkTaskNoticeEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskNoticeRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskNoticeReqVo;

import java.util.Map;

/**
 * 工作任务(抄送) 接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface ISfaWorkTaskNoticeService extends IService<SfaWorkTaskNoticeEntity> {

    /**
     * 列表
     * @param sfaWorkTaskNoticeReqVo
     * @return PageResult<SfaWorkTaskNoticeRespVo>
     */
    PageResult<SfaWorkTaskNoticeRespVo> findList(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 查询
     * @param sfaWorkTaskNoticeReqVo
     * @return SfaWorkTaskNoticeRespVo
     */
    SfaWorkTaskNoticeRespVo query(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 新增
     * @param sfaWorkTaskNoticeReqVo
     * @return
     */
    void save(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 更新
     * @param sfaWorkTaskNoticeReqVo
     * @return
     */
    void update(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 删除
     * @param sfaWorkTaskNoticeReqVo
     * @return
     */
    void deleteBatch(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 启用
     * @param sfaWorkTaskNoticeReqVo
     * @return
     */
    void enableBatch(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 禁用
     * @param sfaWorkTaskNoticeReqVo
     * @return
     */
    void disableBatch(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);
}

