package com.biz.crm.assistant.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReportReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReportRespVo;

import java.util.Map;

/**
 * 工作任务(接收) 接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface ISfaWorkTaskReceveService extends IService<SfaWorkTaskReceveEntity> {

    /**
     * 列表
     * @param sfaWorkTaskReceveReqVo
     * @return PageResult<SfaWorkTaskReceveRespVo>
     */
    PageResult<SfaWorkTaskReceveRespVo> findList(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) throws Exception;

    /**
     * 列表
     * @param sfaWorkTaskReceveReqVo
     * @return PageResult<SfaWorkTaskReceveRespVo>
     */
    PageResult<SfaWorkTaskReceveRespVo> findDayList(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) throws Exception;

    /**
     * 查询当日已完成进度
     * @param reqVo
     * @return
     */
    Map findDayPlan(SfaWorkTaskReceveReqVo reqVo);


    /**
     * 新增
     * @param sfaWorkTaskReceveReqVo
     * @return
     */
    void save(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 更新
     * @param sfaWorkTaskReceveReqVo
     * @return
     */
    void update(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 查询工作任务报表
     * @param reqVo
     * @return
     */
    PageResult<SfaWorkTaskReportRespVo> findSfaWorkTaskReportList(SfaWorkTaskReportReqVo reqVo);

    /**
     * 查看报表详情
     * @param id
     * @return
     */
    SfaWorkTaskReportRespVo findSfaWorkTaskReportById(String id);

}

