package com.biz.crm.assistant.service;

import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;


/**
 * 工作任务(发布) 接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface ISfaWorkTaskReleaseService extends IService<SfaWorkTaskReleaseEntity> {

    /**
     * 列表
     * @param sfaWorkTaskReleaseReqVo
     * @return PageResult<SfaWorkTaskReleaseRespVo>
     */
    PageResult<SfaWorkTaskReleaseRespVo> findList(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 全部列表
     * @param sfaWorkTaskReleaseReqVo
     * @return PageResult<SfaWorkTaskReleaseRespVo>
     */
    PageResult<SfaWorkTaskReleaseRespVo> findListAll(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 查询任务下的某个执行人的执行数据
     */

    SfaWorkTaskReleaseRespVo queryForUserReceve(String receveId);
    /**
     * 查询总任务
     * @param taskId
     * @return SfaWorkTaskReleaseRespVo
     */
    SfaWorkTaskReleaseRespVo query(String taskId);

    /**
     * 新增
     * @param sfaWorkTaskReleaseReqVo
     * @return
     */
    void save(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 更新
     * @param sfaWorkTaskReleaseReqVo
     * @return
     */
    void update(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 任务定时过期策略
     * @param thisTime 当前时间yyyyMMdd
     */
    void timeExpiredTask(String thisTime);

//    /**
//     * 删除
//     * @param sfaWorkTaskReleaseReqVo
//     * @return
//     */
//    void deleteBatch(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

//    /**
//     * 启用
//     * @param sfaWorkTaskReleaseReqVo
//     * @return
//     */
//    void enableBatch(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);
//
//    /**
//     * 禁用
//     * @param sfaWorkTaskReleaseReqVo
//     * @return
//     */
//    void disableBatch(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);
}

