package com.biz.crm.assistant.service.impl;


import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReportTypeEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.*;
import com.biz.crm.nebular.sfa.assistant.resp.*;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.biz.crm.assistant.mapper.SfaWorkSummaryMapper;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;

import java.text.Collator;
import java.time.LocalDate;
import java.util.*;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 工作总结 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaWorkSummaryServiceExpandImpl")
public class SfaWorkSummaryServiceImpl extends ServiceImpl<SfaWorkSummaryMapper, SfaWorkSummaryEntity> implements ISfaWorkSummaryService {

    @Resource
    private SfaWorkSummaryMapper sfaWorkSummaryMapper;

    @Resource
    private MdmPositionFeign mdmPositionFeign;

    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;

    @Autowired
    private ISfaWorkTaskPictureService sfaWorkTaskPictureService;

    @Resource
    private MdmOrgFeign mdmOrgFeign;


    /**
     * 首次查询
     *
     * @param sfaWorkSummaryReqVo
     * @return
     */
    @Override
    public SfaWorkSummaryRespVo findTaskSummary(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        String summaryType = sfaWorkSummaryReqVo.getSummaryType();
        Map<String, String> map = this.gainStartOverBySummaryType(sfaWorkSummaryReqVo.getQueryDate(), summaryType);
        String startDate = map.get("start");
        String overDate = map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.DAILY.getCode());
            SfaWorkSummaryRespVo vo = this.findFirst(sfaWorkSummaryReqVo);
            return vo;
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            //周报
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            //月报
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        return null;
    }

    /**
     * 指定查询
     *
     * @param sfaWorkSummaryStaffReqVo
     * @return
     */
    @Override
    public SfaWorkSummaryRespVo querySummaryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo) {
        String summaryType = sfaWorkSummaryStaffReqVo.getSummaryType();
        Map<String, String> map = this.gainStartOverBySummaryType(sfaWorkSummaryStaffReqVo.getQueryDate(), summaryType);
        String startDate = map.get("start");
        String overDate = map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            //日
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate,
                    overDate, SfaTaskReportTypeEnum.DAILY.getCode());
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            //周
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate,
                    overDate, SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            //月
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate,
                    overDate, SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
        }
        return null;
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaWorkSummaryRespVo
     */
    @Override
    public SfaWorkSummaryRespVo query(SfaWorkSummaryReqVo reqVo) {
        return this.sfaWorkSummaryMapper.findOneById(reqVo.getId());
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSummaryReqVo reqVo) {
        this.checkSaveInNotNull(reqVo);
        this.checkSvaeOnly(reqVo);
        SfaWorkSummaryEntity entity = CrmBeanUtil.copy(reqVo, SfaWorkSummaryEntity.class);
        this.sfaWorkSummaryMapper.insert(entity);
        List<SfaWorkTaskPictureReqVo> vos = reqVo.getPictureReqVos();
        if (vos != null && vos.size() > 0) {
            List<SfaWorkTaskPictureEntity> entities = CrmBeanUtil.copyList(vos, SfaWorkTaskPictureEntity.class);
            //分片插入图片
            for (SfaWorkTaskPictureEntity sfaWorkTaskPictureEntity : entities) {
                sfaWorkTaskPictureEntity.setBusinessId(entity.getId());
                sfaWorkTaskPictureEntity.setPicType(SfaTaskPictureEnum.WORK_SUMMARY.getCode());
            }
            List<List<SfaWorkTaskPictureEntity>> partition = Lists.partition(entities, 50);
            for (List<SfaWorkTaskPictureEntity> sfaWorkTaskPictureEntities : partition) {
                sfaWorkTaskPictureService.saveBatch(sfaWorkTaskPictureEntities);
            }
        }
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    public void update(SfaWorkSummaryReqVo reqVo) {
        SfaWorkSummaryEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 报表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryReportFromsRespVo> summaryReportFroms(SfaWorkSummaryReportFromReqVo reqVo) {
        Page<SfaWorkTaskReceveRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSummaryReportFromsRespVo> forms = sfaWorkSummaryMapper.findListByReportForms(page, reqVo);
        for (SfaWorkSummaryReportFromsRespVo form : forms) {
            form.setPictures(sfaWorkTaskPictureMapper.findListByBusinessId(form.getId()));
            form.setSummaryName(SfaTaskReportTypeEnum.getValue(form.getSummaryType()));
            String createDate = form.getCreateDate();
            if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(form.getSummaryType())) {
                createDate = createDate.substring(0, createDate.lastIndexOf("-"));
            }
            Map<String, String> map = this.gainStartOverBySummaryType(createDate, form.getSummaryType());
            form.setReportStartDate(map.get("start"));
            form.setReportOverDate(map.get("over"));
            MdmOrgRespVo org = mdmOrgFeign.getParentOrg(null, form.getCreateOrgCode()).getResult();
            if (!Objects.isNull(org)) {
                form.setOrgArea(org.getOrgName());
            }
        }
        return PageResult.<SfaWorkSummaryReportFromsRespVo>builder()
                .data(forms)
                .count(page.getTotal())
                .build();
    }

    /**
     * 获取首次查看的数据
     *
     * @param reqVo
     * @return
     */
    public SfaWorkSummaryRespVo findFirst(SfaWorkSummaryReqVo reqVo) {
        //获取当前登录人
        UserRedis user = UserUtils.getUser();
        reqVo = this.writeReqVoByUser(user, reqVo);
        SfaWorkSummaryRespVo byMe = sfaWorkSummaryMapper.findOneByMe(reqVo);

        // 获取组织机构中下级信息
        MdmPositionPageReqVo positionUserOrgReqVo = new MdmPositionPageReqVo();
        positionUserOrgReqVo.setPageSize(10000);
        positionUserOrgReqVo.setPageNum(1);
        //写入职位级别
        Result<PageResult<MdmPositionPageRespVo>> result = mdmPositionFeign.positionAndUserPage(positionUserOrgReqVo);
        List<SfaWorkSummaryStaffRespVo> srList = new ArrayList<>();
        Map<String, Object> map = new HashMap<>();
        if (result != null && result.getResult() != null ) {
            List<MdmPositionPageRespVo> userList = result.getResult().getData();
//            List<MdmPositionUserOrgRespVo> resultResult = result.getResult();
            userList = this.gainAlphabetically(userList);
            map = this.gainReportStatus(userList, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
            for (MdmPositionPageRespVo mdmPositionPageRespVo : userList) {
                srList.add(this.mdmPuTostaff(mdmPositionPageRespVo, map));
            }
        }
        //根据本人去找是否有已提交日/周/月报
        if (!Objects.isNull(byMe)) {
            byMe.setLocalDisk("1");
            byMe.setStaffRespVos(srList);
            if (srList.size() > 1) {
                byMe.setStaffRespVoDown(srList.get(1));
            }
            for (SfaWorkSummaryStaffRespVo staffRespVo : srList) {
                String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                if (map.containsKey(mapKey)) {
                    byMe.setStaffRespVoDown(staffRespVo);
                }
            }
            List<SfaWorkTaskPictureRespVo> byBusinessId = sfaWorkTaskPictureMapper.findListByBusinessId(byMe.getId());
            byMe.setPictureRespVos(byBusinessId);
            return byMe;
        }
        boolean b = true;
        SfaWorkSummaryRespVo one = null;
        for (int i = 0; i < srList.size(); i++) {
            SfaWorkSummaryStaffRespVo staffRespVo = srList.get(i);
            String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
            if (b && map.containsKey(mapKey)) {
                SfaWorkSummaryStaffReqVo copy = CrmBeanUtil.copy(staffRespVo, SfaWorkSummaryStaffReqVo.class);
                one = sfaWorkSummaryMapper.findOneByLists(copy, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
                if (Objects.isNull(one)) {
                    one = this.writeDefaultValue(null, staffRespVo.getSummaryCode(), staffRespVo.getSummaryName(), staffRespVo.getOrgName());
                } else {
                    one.setReportShowType("1");
                    one.setLocalDisk("0");
                    List<SfaWorkTaskPictureRespVo> byBusinessId = sfaWorkTaskPictureMapper.findListByBusinessId(one.getId());
                    one.setPictureRespVos(byBusinessId);
                }
                one.setStaffRespVos(srList);
                b = false;
                continue;
            }
            if (map.containsKey(mapKey)) {
                one.setStaffRespVoDown(staffRespVo);
            }
        }
        //首次并且下级无报告且本身也无报告
        if (Objects.isNull(one)) {
            one = this.writeDefaultValue(null, user.getUsername(), user.getRealname(), user.getPosname());
            one.setStaffRespVos(srList);
        }
        return one;
    }


    /**
     * 查询指定人指定时间的详情(包含上下页)
     *
     * @param reqVo
     * @param startDate
     * @param overDate
     * @param summaryType
     * @return
     */
    private SfaWorkSummaryRespVo queryOnes(SfaWorkSummaryStaffReqVo reqVo, String startDate, String overDate,
                                           String summaryType) {
        this.checkByqueryOnes(reqVo);
        UserRedis user = UserUtils.getUser();
        //非本人
        SfaWorkSummaryRespVo summaryRespVo = sfaWorkSummaryMapper.findOneByLists(reqVo, startDate, overDate, summaryType);
        if (Objects.isNull(summaryRespVo)) {
            summaryRespVo = this.writeDefaultValue(null, reqVo.getSummaryCode(), reqVo.getSummaryName(), null);
        } else {
            summaryRespVo.setReportShowType("1");
        }

        List<SfaWorkSummaryStaffRespVo> userList = Lists.newArrayList();
        boolean b = this.loadUserList( reqVo,  summaryRespVo,  startDate,  overDate,
                summaryType, userList);
        //校验是否是本人选择本人
        if(!b && reqVo.getSummaryCode().equals(user.getUsername()) && reqVo.getOrgCode().equals(user.getOrgcode()) &&
                reqVo.getPosCode().equals(user.getPoscode())){
            summaryRespVo = this.writeDefaultValue(summaryRespVo, user.getUsername(), user.getRealname(), user.getPosname());
            summaryRespVo.setStaffRespVos(userList);
        }
        if (StringUtils.isNotEmpty(summaryRespVo.getId())) {
            List<SfaWorkTaskPictureRespVo> byBusinessId = sfaWorkTaskPictureMapper.findListByBusinessId(summaryRespVo.getId());
            summaryRespVo.setPictureRespVos(byBusinessId);
        }
        return summaryRespVo;
    }


    /**
     * 加载用户列表
     * @param reqVo
     * @param summaryRespVo
     * @param startDate
     * @param overDate
     * @param summaryType
     * @param userList
     * @return
     */
    private boolean loadUserList(SfaWorkSummaryStaffReqVo reqVo, SfaWorkSummaryRespVo summaryRespVo, String startDate, String overDate,
                    String summaryType, List<SfaWorkSummaryStaffRespVo> userList){
        /**
         * 就是这个 B 写的代码
         */
        boolean b = false;
        //获取当前登陆人的日周月报
        SfaWorkSummaryReqVo summaryReqVo = this.writeReqVoByUser(UserUtils.getUser(), null);
        summaryReqVo.setStartDate(startDate);
        summaryReqVo.setOverDate(overDate);
        summaryReqVo.setSummaryType(summaryType);
        SfaWorkSummaryRespVo byMe = sfaWorkSummaryMapper.findOneByMe(summaryReqVo);
        //当前登陆人是否有报告
        if (!Objects.isNull(byMe)) {
            summaryRespVo.setLocalDisk("1");
            b = true;
        } else {
            summaryRespVo.setLocalDisk("0");
        }
        int thisSubscript = -1;
        // 获取组织机构中下级信息
        MdmPositionPageReqVo mdmPositionPageReqVo = new MdmPositionPageReqVo();
        mdmPositionPageReqVo.setPageSize(10000);
        mdmPositionPageReqVo.setPageNum(1);
        //写入职位级别
        Result<PageResult<MdmPositionPageRespVo>> result = mdmPositionFeign.positionAndUserPage(mdmPositionPageReqVo);
//        //获取所有下级
//        Result<List<MdmPositionUserOrgRespVo>> result = mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        ApiResultUtil.objResult(result, true);
        List<MdmPositionPageRespVo> userListAsMdm = result.getResult().getData();
        userListAsMdm = this.gainAlphabetically(userListAsMdm);
        Map<String, Object> map = this.gainReportStatus(userListAsMdm, summaryReqVo.getStartDate(), summaryReqVo.getOverDate(), reqVo.getSummaryType());
        for (int i = 0; i < userListAsMdm.size(); i++) {
            MdmPositionPageRespVo mdmPositionPageRespVo = userListAsMdm.get(i);
            SfaWorkSummaryStaffRespVo respVo = this.mdmPuTostaff(mdmPositionPageRespVo, map);
            userList.add(respVo);
            if (reqVo.getSummaryCode().equals(respVo.getSummaryCode()) && reqVo.getOrgCode().equals(respVo.getOrgCode()) &&
                    reqVo.getPosCode().equals(respVo.getPosCode())) {
                thisSubscript = i;
                summaryRespVo.setCreatePosName(mdmPositionPageRespVo.getPositionName());
                summaryRespVo.setCreateName(mdmPositionPageRespVo.getFullName());
            }
        }
        summaryRespVo.setStaffRespVos(userList);

        if (thisSubscript > 0) {
            //上一页(有日周月报)
            for (int j = thisSubscript - 1; j >= 0; j--) {
                SfaWorkSummaryStaffRespVo staffRespVo = userList.get(j);
                String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                if (map.containsKey(mapKey)) {
                    summaryRespVo.setStaffRespVoUp(userList.get(j));
                    break;
                }
            }
        }
        //当前登陆人有报告并且上一页为空
        if (b && Objects.isNull(summaryRespVo.getStaffRespVoUp()) && thisSubscript != -1) {
            SfaWorkSummaryStaffRespVo byMeRespVo = new SfaWorkSummaryStaffRespVo();
            byMeRespVo.setPosCode(byMe.getCreatePosCode());
            byMeRespVo.setPosName(byMe.getCreatePosName());
            byMeRespVo.setSummaryCode(byMe.getCreateCode());
            byMeRespVo.setSummaryName(byMe.getCreateName());
            byMeRespVo.setOrgCode(byMe.getCreateOrgCode());
            byMeRespVo.setOrgName(byMe.getCreateOrgName());
            byMeRespVo.setReportStatus("1");
            summaryRespVo.setStaffRespVoUp(byMeRespVo);
        }
        if (thisSubscript < userList.size() - 1) {
            //下一页(有周日月报)
            for (int i = thisSubscript + 1; i < userList.size(); i++) {
                SfaWorkSummaryStaffRespVo staffRespVo = userList.get(i);
                String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                if (map.containsKey(mapKey)) {
                    summaryRespVo.setStaffRespVoDown(userList.get(i));
                    break;
                }
            }
        }
        return b;
    }

    /**
     * 根据time和type 返回时间段
     *
     * @param time        yyyy-MM-dd
     * @param summaryType
     * @return map<String, String>("start/over",time)
     */
    private Map<String, String> gainStartOverBySummaryType(String time, String summaryType) {
        LocalDate date = null;
        String startDate = "";
        String overDate = "";
        Map<String, String> map = new HashMap<>(2);
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            //当天
            if (StringUtils.isEmpty(time)) {
                date = LocalDate.now();
            } else {
                date = LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            }
            startDate = date.format(CrmDateUtils.yyyyMMdd);
            overDate = date.format(CrmDateUtils.yyyyMMdd);
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            //本周1
            if (StringUtils.isEmpty(time)) {
                date = LocalDate.now();
            } else {
                date = LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            }
            startDate = CrmDateUtils.gainMonday(date);
            overDate = CrmDateUtils.gainSunday(date);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            //月
            //当天
            if (StringUtils.isEmpty(time)) {
                date = LocalDate.now();
            } else {
                date = LocalDate.parse(time + "-01", CrmDateUtils.yyyyMMdd);
            }
            startDate = CrmDateUtils.gainFirstMonth(date);
            overDate = CrmDateUtils.gainLastMonth(date);
        }
        map.put("start", startDate);
        map.put("over", overDate);
        return map;
    }

    /**
     * 验证保存数据唯一
     *
     * @return
     */
    private void checkSvaeOnly(SfaWorkSummaryReqVo reqVo) {
        String summaryType = reqVo.getSummaryType();
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Map<String, String> map = this.gainStartOverBySummaryType(reqVo.getQueryDate(), reqVo.getSummaryType());
        reqVo.setStartDate(map.get("start"));
        reqVo.setOverDate(map.get("over"));
        SfaWorkSummaryRespVo oneByMe = sfaWorkSummaryMapper.findOneByMe(reqVo);
        if (!Objects.isNull(oneByMe)) {
            throw new BusinessException("当前" + SfaTaskReportTypeEnum.getValue(summaryType) + "已存在");
        }
    }

    /**
     * 数据判空
     *
     * @param reqVo
     */
    private void checkSaveInNotNull(SfaWorkSummaryReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getContent(), "总结内容不能为空");
        AssertUtils.isNotEmpty(reqVo.getWordPlan(), "工作计划不能为空");
    }

    /**
     * 转换
     *
     * @param respVo
     * @return
     */
    private SfaWorkSummaryStaffRespVo mdmPuTostaff(MdmPositionPageRespVo respVo, Map<String, Object> map) {
        SfaWorkSummaryStaffRespVo staffRespVo = new SfaWorkSummaryStaffRespVo();
        String mapKey = respVo.getUserName() + respVo.getPositionCode() + respVo.getOrgCode();
        staffRespVo.setSummaryName(respVo.getFullName());
        staffRespVo.setSummaryCode(respVo.getUserName());
        staffRespVo.setPosCode(respVo.getPositionCode());
        staffRespVo.setPosName(respVo.getPositionName());
        staffRespVo.setOrgCode(respVo.getOrgCode());
        staffRespVo.setOrgName(respVo.getOrgName());
        if (map.containsKey(mapKey)) {
            staffRespVo.setReportStatus("1");
        } else {
            staffRespVo.setReportStatus("0");
        }
        return staffRespVo;
    }

    /**
     * 按照首字母排序
     *
     * @return
     */
    private List<MdmPositionPageRespVo> gainAlphabetically(List<MdmPositionPageRespVo> list) {
        // 获取中文环境
        Comparator comparator = Collator.getInstance(Locale.CHINA);
        // 排序实现
        Collections.sort(list, (first, next) -> {
            if (StringUtils.isEmpty(first.getFullName()) && StringUtils.isEmpty(next.getFullName())) {
                return 0;
            }
            if (StringUtils.isEmpty(first.getFullName())) {
                return 1;
            }
            if (StringUtils.isEmpty(next.getFullName())) {
                return -1;
            }
            return comparator.compare(first.getFullName(), next.getFullName());
        });
        return list;
    }

    /**
     * 校验入参数
     *
     * @param reqVo
     */
    private void checkByqueryOnes(SfaWorkSummaryStaffReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getSummaryCode(), "用户的账号不能为空");
        AssertUtils.isNotEmpty(reqVo.getOrgCode(), "用户的组织不能为空");
        AssertUtils.isNotEmpty(reqVo.getPosCode(), "用户的职位不能为空");
    }

    /**
     * 根据集合查询当前时间段内当前角色集合的报告提交状态
     *
     * @param respVos
     * @return map<username + poscode + orgcode, null>
     */
    private Map<String, Object> gainReportStatus(List<MdmPositionPageRespVo> respVos, String startDate, String overDate, String summaryType) {
        Map<String, Object> map = new HashMap<>();
        if (!CollectionUtil.listEmpty(respVos)) {
            List<SfaWorkSummaryStaffRespVo> vos = sfaWorkSummaryMapper.queryReportStatus(respVos, startDate, overDate, summaryType);
            if (!CollectionUtil.listEmpty(vos) && vos.size() > 0) {
                vos.forEach(f -> map.put(f.getSummaryCode() + f.getPosCode() + f.getOrgCode(), null));
            }
        }
        return map;
    }

    /**
     * 写入默认值
     *
     * @return
     */
    private SfaWorkSummaryRespVo writeDefaultValue(SfaWorkSummaryRespVo respVo, String createCode, String createName, String posName) {
        if (Objects.isNull(respVo)) {
            respVo = new SfaWorkSummaryRespVo();
        }
        respVo.setReportShowType("0");
        respVo.setCreateCode(createCode);
        respVo.setCreateName(createName);
        respVo.setCreatePosName(posName);
        respVo.setLocalDisk("0");
        return respVo;
    }

    /**
     * 当前用户查询
     *
     * @param user
     * @return
     */
    private SfaWorkSummaryReqVo writeReqVoByUser(UserRedis user, SfaWorkSummaryReqVo reqVo) {
        if (Objects.isNull(reqVo)) {
            reqVo = new SfaWorkSummaryReqVo();
        }
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        return reqVo;
    }

    /**
     * 获取某月完成日报  默认登月
     * @param sfaWorkSummaryReqVo
     * @return
     */
    @Override
    public Integer getSfaWorkSummaryByCount(SfaWorkSummaryReqVo sfaWorkSummaryReqVo){
        if (null == sfaWorkSummaryReqVo){
            sfaWorkSummaryReqVo = new SfaWorkSummaryReqVo();
            sfaWorkSummaryReqVo.setUserCode(UserUtils.getUser().getUsername());
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.DAILY.getCode());
            sfaWorkSummaryReqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        if(StringUtils.isEmpty(sfaWorkSummaryReqVo.getUserCode())){
            sfaWorkSummaryReqVo.setUserCode(UserUtils.getUser().getUsername());
        }
        if(StringUtils.isEmpty(sfaWorkSummaryReqVo.getSummaryType())){
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.DAILY.getCode());
        }
        if(StringUtils.isEmpty(sfaWorkSummaryReqVo.getYearMonth())){
            sfaWorkSummaryReqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        return sfaWorkSummaryMapper.getSfaWorkSummaryByCount(sfaWorkSummaryReqVo);
    }

    /**
     * 获取某月完成日报  默认本月
     * @param sfaWorkSummaryReqVo
     * @return
     */
    @Override
    public Integer getSfaWorkSummaryPrimaryByCount(SfaWorkSummaryReqVo sfaWorkSummaryReqVo){
        if (null == sfaWorkSummaryReqVo){
            sfaWorkSummaryReqVo = new SfaWorkSummaryReqVo();
            sfaWorkSummaryReqVo.setUserCode(UserUtils.getUser().getUsername());
            sfaWorkSummaryReqVo.setSummaryType(SfaWorkSummaryEnum.LectureType.DAILY.getVal());
            sfaWorkSummaryReqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        if(StringUtils.isEmpty(sfaWorkSummaryReqVo.getUserCode())){
            sfaWorkSummaryReqVo.setUserCode(UserUtils.getUser().getUsername());
        }
        if(StringUtils.isEmpty(sfaWorkSummaryReqVo.getSummaryType())){
            sfaWorkSummaryReqVo.setSummaryType(SfaWorkSummaryEnum.LectureType.DAILY.getVal());
        }
        if(StringUtils.isEmpty(sfaWorkSummaryReqVo.getYearMonth())){
            sfaWorkSummaryReqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        return sfaWorkSummaryMapper.getSfaWorkSummaryPrimaryByCount(sfaWorkSummaryReqVo);
    }

}
