package com.biz.crm.base.utils;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.util.*;

import java.util.Map;

/**
 * sfa调用bpm审批流 统一工具类
 * @author YuanZiJian
 * @date 2021/3/18 19:59
 * @version: V1.0
 */
public class ProcessUtil {
    /**
     * 统一:sfa工作流 processKey 存在于数据字典:
     * activiti_apply_keys
     */
    private static final String DictValue = "activiti_apply_keys" ;

    private static TaActBaseFeign taActBaseFeign = SpringApplicationContextUtil.getApplicationContext().getBean(TaActBaseFeign.class);

    /**
     * 启动审批工作流——统一提交sfa交给审批流的参数配置
     * @method startProcess
     * @date: 2021/3/18 20:18
     * @author: YuanZiJian
     * @param id sfa业务的Id——ps:不是工作流的Id
     * @param formTypeEnum ActivitiEnum的FromTypeEnum中配置对应的审批类型
     * @return java.lang.String
     */
     public static   String startProcess(String id ,ActivitiEnum.FormTypeEnum formTypeEnum  ){
        //开启审批流
         String processNo = ActivityUtils.startProcess(buildProcessReqVo(id, formTypeEnum));
        return processNo;
    }

    /**
     * 创建工作流的启动Vo
     * @method buildProcessReqVo
     * @date: 2021/3/18 20:18
     * @author: YuanZiJian
     * @param formNo 业务id对应工作流的fromId
     * @param formTypeEnum 上传审批，需要定义好的参数
     * @return com.biz.crm.nebular.activiti.act.req.StartProcessReqVo
     */
    private static StartProcessReqVo buildProcessReqVo(String formNo , ActivitiEnum.FormTypeEnum formTypeEnum ) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo process = new StartProcessReqVo();
        /*
         * 流程实体必填项
         * 1.用户编码（userCode) 发起流程的用户账号名
         * 2.岗位编码（posCode）发起流程的用户岗位
         * 3.流程Key（processKey） 发起流程的流程Key，到流程绘制中添加流程
         * 4.业务单号（formNo)
         * 5.表单标题（title）
         * 6.表单URL（formUrl)
         * 7.回调方法的feign(callBackFeign）流程调用的回调接口
         * 8.防重复验证码
         */
        process.setUserCode(user.getUsername());
        process.setPosCode(user.getPoscode());
        // 通过数据字段获取流程key信息,这里需要新建枚举值
        String processKey = null;
        Map<String, String> map = DictUtil.getDictValueMapsByCodes(DictValue);
        if (map == null) {
            throw new BusinessException("请配置<数据字典>:"+DictValue);
        }
        processKey = map.get(formTypeEnum.getProcessKey());
        if (StringUtils.isEmpty(processKey)) {
            throw new BusinessException("请在数据字典"+DictValue+"中添加字典");
        }
        process.setProcessKey(processKey);
        process.setTitle(formTypeEnum.getTitle());
        process.setFormUrl("https");
        process.setFormNo(formNo);
        process.setCostType(formTypeEnum.getCostType());
        process.setFormType(formTypeEnum.getFormType());
        process.setCallBackFeign(formTypeEnum.getCallBackFeign());
        process.setSignTicket(UUIDGenerator.generate());
        return process;
    }


}
