package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.cache.util
 * @Description: 查询登陆用户的总积分 工具类
 * @date 2021/4/7 下午1:53
 */
@Component
public class IntegralUserUtil {
    /**
     * 获取工作台页面——所有的气泡和通知
     * com.biz.crm.integral.service.SfaIntegralDetailService#countIntegralNumByUserName(java.lang.String)
     * 此初换设置1个小时 ==>如发现需要实时更新的可以通过本工具类删除缓存key==>deleteKey
     */
    /**
     * redis缓存key
     */
    public static final String redisKey = "SFAINTEGRALDETAILSERVICE:COUNTINTEGRALNUMBYUSERNAME:v1:";
    @Autowired
    private RedisService redisService;
    @Autowired
    private SfaIntegralDetailService sfaIntegralDetailService;


    //获取编码
    public String getKey(String userName){
        if(StringUtils.isEmpty(userName)){
            throw new BusinessException("参数错误");
        }
        return redisKey+userName;
    }

    //删除缓存
    public void deleteKey(String userName){
        redisService.del(getKey(userName));
    }
    //设置缓存
    public void setObj(SfaIntegralUserRankRespVo vo){
        String key = getKey(vo.getUserName());
        redisService.setHours(key,vo, RedisParam.TIME1);
    }
    //获取对象
    public SfaIntegralUserRankRespVo getObj(String userName){
        Object o = redisService.get(getKey(userName));
        if(o==null){
            return compensate(userName);
        }
        SfaIntegralUserRankRespVo vo = (SfaIntegralUserRankRespVo)o;
        if(StringUtils.isEmpty(vo.getUserName())){
            return null;
        }
        return vo;
    }

    //缓存丢失补偿  数据库如果没有设置空对象 userName 默认空字符串
    public SfaIntegralUserRankRespVo compensate(String userName){
        SfaIntegralUserRankRespVo vo = sfaIntegralDetailService.countIntegralNumByUserNameRedis(null);
        vo = vo==null?new SfaIntegralUserRankRespVo():vo;
        vo.setUserName(userName);
        setObj(vo);
        return vo;
    }
}
