package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.worksign.util
 * @Description: 考勤明细工具类
 * @date 2021/4/6 下午9:47
 */
@Component
public class SfaWorkSignRuleInfoUtil {
    /**
     * redis缓存key
     */
    public static final String redisKey = "SFA_WORK_SIGN_RULE_INFO:v1:";
    @Autowired
    private RedisService redisService;
    @Resource
    private ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;


    //获取编码
    public String getKey(String userName,String ruleDate){
        if(StringUtils.isEmpty(userName)||StringUtils.isEmpty(ruleDate)){
            throw new BusinessException("参数错误");
        }
        return redisKey+userName+ruleDate;
    }

    //删除缓存
    public void deleteKey(String userName,String ruleDate){
        redisService.del(getKey(userName,ruleDate));
    }
    //设置缓存
    public void setObj(SfaWorkSignRuleInfoEntity vo,String key){
        redisService.setDays(key,vo, RedisParam.TIME30);
    }
    //获取对象
    public SfaWorkSignRuleInfoEntity getObj(String userName,String ruleDate){
        //TODO 临时不加缓存
        SfaWorkSignRuleInfoEntity entity = iSfaWorkSignRuleInfoService.findByUserNameAndRuleDate(userName, ruleDate);
        return entity;


//        Object o = redisService.get(getKey(userName,ruleDate));
//        if(o==null){
//            return compensate(userName,ruleDate);
//        }
//        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)o;
//        if(StringUtils.isEmpty(entity.getUserName())){
//            return null;
//        }
//        return entity;
    }

    //缓存丢失补偿  数据库如果没有设置空对象 UserName 默认空字符串
    public SfaWorkSignRuleInfoEntity compensate(String userName,String ruleDate){
        if(StringUtils.isEmpty(userName) || StringUtils.isEmpty(ruleDate)) {
            throw new BusinessException("参数错误");
        }
        String key = getKey(userName, ruleDate);

        SfaWorkSignRuleInfoEntity entity = iSfaWorkSignRuleInfoService.findByUserNameAndRuleDate(userName, ruleDate);
        if(entity == null) {
            entity = new SfaWorkSignRuleInfoEntity();
        }
        setObj(entity,key);
        return entity;
    }
}
