package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.cache.util
 * @Description: 工作台缓存
 * @date 2021/4/7 下午1:02
 */
@Component
public class WorkUtil {
    /**
     * 获取工作台页面——所有的气泡和通知
     * com.biz.crm.worksign.service.impl.SfaWorkSignRuleInfoServiceImpl.getAllNotice
     * 此初换设置1个小时 ==>如发现需要实时更新的可以通过本工具类删除缓存key==>deleteKey
     */
    /**
     * redis缓存key
     */
    public static final String redisKey = "SFAWORKSIGNRULEINFOSERVICE:GETALLNOTICE:v1:";
    @Autowired
    private RedisService redisService;
    @Autowired
    private ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;


    //获取编码
    public String getKey(String positionCode){
        if(StringUtils.isEmpty(positionCode)){
            throw new BusinessException("参数错误");
        }
        return redisKey+positionCode;
    }

    //删除缓存
    public void deleteKey(String positionCode){
        redisService.del(getKey(positionCode));
    }
    //设置缓存
    public void setObj(SfaNoticeRespVo vo){
        UserRedis userRedis = UserUtils.getUser();
        String key = getKey(userRedis.getPoscode());
        redisService.setMinutes(key,vo,RedisParam.TIME5);
    }
    //获取对象
    public SfaNoticeRespVo getObj(String positionCode){
        Object o = redisService.get(getKey(positionCode));
        if(o==null){
            return compensate(positionCode);
        }
        SfaNoticeRespVo vo = (SfaNoticeRespVo)o;
        if(StringUtils.isEmpty(vo.getPositionCode())){
            return null;
        }
        return vo;
    }

    //缓存丢失补偿  数据库如果没有设置空对象 positionCode 默认空字符串
    public SfaNoticeRespVo compensate(String positionCode){
        SfaNoticeRespVo sfaNoticeRespVo = iSfaWorkSignRuleInfoService.getAllNoticeRedis();
        sfaNoticeRespVo = sfaNoticeRespVo==null?new SfaNoticeRespVo():sfaNoticeRespVo;
        sfaNoticeRespVo.setPositionCode(positionCode);
        setObj(sfaNoticeRespVo);
        return sfaNoticeRespVo;
    }
}
