package com.biz.crm.calculatesalary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.calculatesalary.model.SfaCalculateSalaryDateEntity;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 计算薪资日期
 * 
 * @author lf
 * @date 2020-12-28 15:00:09
 */
public interface SfaCalculateSalaryDateMapper extends BaseMapper<SfaCalculateSalaryDateEntity> {
    /**
     * 列表
     * @param page
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    List<SfaCalculateSalaryDateRespVo> findList(Page<SfaCalculateSalaryDateRespVo> page, @Param("vo") SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 通过条件查询list
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    List<SfaCalculateSalaryDateRespVo> selectListByCondition(@Param("vo") SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 通过年份删除数据信息
     * @param year
     * @return
     */
    Integer deleteSalaryDateByYear(String year);

}
