package com.biz.crm.calculatesalary.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.calculatesalary.model.SfaCalculateSalaryYearEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryYearReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryYearRespVo;

import java.util.List;

/**
 * 计算薪资年 接口
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
public interface ISfaCalculateSalaryYearService extends IService<SfaCalculateSalaryYearEntity> {

    /**
     * 列表
     * @param sfaCalculateSalaryYearReqVo
     * @return PageResult<SfaCalculateSalaryYearRespVo>
     */
    PageResult<SfaCalculateSalaryYearRespVo> findList(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 查询明细
     * @param id
     * @return
     */
    SfaCalculateSalaryYearRespVo queryDetailById(String id);

    /**
     * 查询
     * @param sfaCalculateSalaryYearReqVo
     * @return SfaCalculateSalaryYearRespVo
     */
    SfaCalculateSalaryYearRespVo query(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 新增
     * @param sfaCalculateSalaryYearReqVo
     * @return
     */
    void save(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 更新
     * @param sfaCalculateSalaryYearReqVo
     * @return
     */
    void update(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 查询年份列表
     * @return
     */
    List<String> getYearList();
}

