package com.biz.crm.checkin.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupSaveReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.util.AssertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.checkin.service.ISfaCheckInGroupService;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 后台-考勤管理-签到组
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@RestController
@RequestMapping("/sfacheckingroup")
@Api(tags = "后台-考勤管理-签到组")
public class SfaCheckInGroupController {
    @Autowired
    private ISfaCheckInGroupService sfaCheckInGroupService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaCheckInGroupRespVo>> list(@RequestBody SfaCheckInGroupReqVo sfaCheckInGroupReqVo) {
        PageResult<SfaCheckInGroupRespVo> result=sfaCheckInGroupService.findList(sfaCheckInGroupReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmDictMethod
    public Result<SfaCheckInGroupRespVo> query(@RequestBody String id) {
        SfaCheckInGroupRespVo respVo=sfaCheckInGroupService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增or编辑
     */
    @ApiOperation(value = "新增or编辑")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaCheckInGroupSaveReqVo reqVo) {

        sfaCheckInGroupService.save(reqVo);
        return Result.ok();
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, "id不能为空");
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setIds(ids);
        sfaCheckInGroupService.deleteBatch(reqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, "id不能为空");
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setIds(ids);
        sfaCheckInGroupService.enableBatch(reqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, "id不能为空");
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setIds(ids);
        sfaCheckInGroupService.disableBatch(reqVo);
        return Result.ok("禁用成功");
    }
}
