package com.biz.crm.checkin.controller;

import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInTypeReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInTypeRespVo;
import com.biz.crm.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.checkin.service.ISfaCheckInTypeService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 后台-考勤管理-签到组-打卡类型
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@RestController
@RequestMapping("/sfacheckintype")
@Api(tags = "后台-考勤管理-签到组-打卡类型")
public class SfaCheckInTypeController {
    @Autowired
    private ISfaCheckInTypeService sfaCheckInTypeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaCheckInTypeRespVo>> list(@RequestBody SfaCheckInTypeReqVo sfaCheckInTypeReqVo) {
        sfaCheckInTypeReqVo.setCreateCode(UserUtils.getUser().getUsername());
        PageResult<SfaCheckInTypeRespVo> result=sfaCheckInTypeService.findList(sfaCheckInTypeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaCheckInTypeRespVo> query(@RequestBody String id) {
        SfaCheckInTypeRespVo respVo=sfaCheckInTypeService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增or编辑
     */
    @ApiOperation(value = "新增or编辑")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaCheckInTypeReqVo sfaCheckInTypeReqVo) {
        sfaCheckInTypeService.save(sfaCheckInTypeReqVo);
        return Result.ok();
    }


    /**
     * 删除
     */
    @ApiOperation(value = "删除(逻辑删除)")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        SfaCheckInTypeReqVo reqVo = new SfaCheckInTypeReqVo();
        reqVo.setIds(ids);
        sfaCheckInTypeService.deleteBatch(reqVo);
        return Result.ok("删除成功");
    }

}
