package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组;实体类
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_group")
@CrmTable(name = "sfa_check_in_group", tableNote = "签到组")
public class SfaCheckInGroupEntity extends CrmExtTenEntity<SfaCheckInGroupEntity>{

    /**
     * 签到组名称
     */
    @CrmColumn(name = "group_name", length = 128, note = "签到组名称")
    private String groupName;

    /**
     * 签到组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "签到组编码")
    private String groupCode;
    @CrmColumn(name = "time_type" , length = 10 , note = "有效时间类型")
    private String timeType;
    @CrmColumn(name = "electron_fence_type" , length = 200 , note = "电子围栏类型")
    private String electronFenceType;

}
