package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组-打卡类型;实体类
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_group_type")
@CrmTable(name = "sfa_check_in_group_type", tableNote = "签到组-打卡类型")
public class SfaCheckInGroupTypeEntity extends CrmExtTenEntity<SfaCheckInGroupTypeEntity> {

    /**
     * 签到组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "签到组编码")
    private String groupCode;

    /**
     * 打卡类型id
     */
    @CrmColumn(name = "sfa_check_in_type_id", length = 64, note = "打卡类型id")
    private String sfaCheckInTypeId;

}
