package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;


/**
 * 签到组地址;实体类
 * @author YuanZiJian
 * @date 2021/2/26 13:17
 * @version: V1.0
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_place")
@CrmTable(name = "sfa_check_in_place", tableNote = "签到组地址")
public class SfaCheckInPlaceEntity extends CrmExtTenEntity {
    /**
     * 所属签到组编码
     */
    @CrmColumn(name = "group_code" ,length = 32, note = "所属签到组编码")
    private String groupCode;

    /**
     * 名称
     */
    @CrmColumn(name = "name" ,length = 100, note = "名称")
    private String name;

    /**
     * 地址
     */
    @CrmColumn(name = "address" ,length = 100, note = "地址")
    private String address;

    /**
     * 地点经度
     */
    @CrmColumn(name = "place_lngin" ,length = 32, note = "地点经度")
    private String placeLngin;

    /**
     * 地点纬度
     */
    @CrmColumn(name = "place_latin" ,length = 32, note = "地点纬度")
    private String placeLatin;

    /**
     * 打卡范围
     */
    @CrmColumn(name = "sign_place_scope" ,length = 20, note = "打卡范围")
    private String signPlaceScope;
}
