package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 签到组-签到图片实体类
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_sign_group_report")
@CrmTable(name = "sfa_check_in_sign_group_report", tableNote = "签到组-签到图片",indexes = {
        @Index(name = "sfa_check_in_sign_group_report_index1",columnList = "sfa_check_in_sign_record_id")
})
public class SfaCheckInSignGroupReportEntity extends CrmExtTenEntity<SfaCheckInSignGroupReportEntity> {
    /**
     * 签到组-签到记录id
     */
    @CrmColumn(name = "sfa_check_in_sign_record_id", length = 32, note = "签到组-签到记录id")
    private String sfaCheckInSignRecordId;

    /**
     * 签到组编号
     */
    @CrmColumn(name = "group_code", length = 512, note = "签到组编号")
    private String groupCode;

    /**
     * 签到组名称
     */
    @CrmColumn(name = "group_name", length = 512, note = "签到组名称")
    private String groupName;

    /**
     * 签到日期id
     */
    @CrmColumn(name = "check_in_date_id", length = 100, note = "签到日期id")
    private String checkInDateId;

    /**
     * 签到日期
     */
    @CrmColumn(name = "check_in_date", length = 100, note = "签到日期")
    private String checkInDate;

    /**
     * 打卡类型id
     */
    @CrmColumn(name = "check_in_type_id", length = 100, note = "活动编码")
    private String checkInTypeId;

    /**
     * 打卡类型名称
     */
    @CrmColumn(name = "check_in_type_name", length = 100, note = "打卡类型名称")
    private String checkInTypeName;

    /**
     * 签到人员帐号
     */
    @CrmColumn(name = "user_name", length = 200, note = "签到人员帐号")
    private String userName;

    /**
     * 签到人员名称
     */
    @CrmColumn(name = "real_name", length = 200, note = "签到人员名称")
    private String realName;

    /**
     * 人员职位编码
     */
    @CrmColumn(name = "pos_code", length = 200, note = "人员职位编码")
    private String posCode;

    /**
     * 人员职位名称
     */
    @CrmColumn(name = "pos_name", length = 200, note = "人员职位名称")
    private String posName;

    /**
     * 人员组织编码
     */
    @CrmColumn(name = "org_code", length = 200, note = "人员组织编码")
    private String orgCode;

    /**
     * 人员组织名称
     */
    @CrmColumn(name = "org_name", length = 200, note = "人员组织名称")
    private String orgName;

    /**
     * 人员上级组织编码
     */
    @CrmColumn(name = "parent_org_code", length = 200, note = "人员上级组织编码")
    private String parentOrgCode;

    /**
     * 人员上级组织名称
     */
    @CrmColumn(name = "parent_org_name", length = 200, note = "人员上级组织名称")
    private String parentOrgName;

    /**
     * 签到状态 NONE:未打卡;OK:正常
     */
    @CrmColumn(name = "sign_status", length = 64, note = "签到状态 NONE:未打卡;OK:正常")
    private String signStatus;
    /**
     * 签到状态 NONE:未打卡;OK:正常
     */
    @CrmColumn(name = "sign_status_name", length = 64, note = "签到状态 NONE:未打卡;OK:正常")
    private String signStatusName;
    /**
     * 签到地点异常状态 Y:是;N:否
     */
    @CrmColumn(name = "sign_place_ex_status", length = 64, note = "签到地点异常状态 Y:是;N:否")
    private String signPlaceExStatus;
    @CrmColumn(name = "sign_place_ex_status_name", length = 64, note = "签到地点异常状态 Y:是;N:否")
    private String signPlaceExStatusName;

}
