package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组-签到记录实体类
 *
 * @author fily
 * @date 2021-01-05 13:12:38
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_sign_record")
@CrmTable(name = "sfa_check_in_sign_record", tableNote = "签到组-签到记录")
public class SfaCheckInSignRecordEntity extends CrmExtTenEntity<SfaCheckInSignRecordEntity> {

    /**
     * 签到组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "签到组编码")
    private String groupCode;

    /**
     * 签到组名称
     */
    @CrmColumn(name = "group_name", length = 400, note = "签到组名称")
    private String groupName;

    /**
     * 签到日期id
     */
    @CrmColumn(name = "check_in_date_id", length = 100, note = "签到日期id")
    private String checkInDateId;

    /**
     * 打卡类型id
     */
    @CrmColumn(name = "check_in_type_id", length = 64, note = "打卡类型id")
    private String checkInTypeId;

    /**
     * 打卡类型名称
     */
    @CrmColumn(name = "check_in_type_name", length = 512, note = "打卡类型名称")
    private String checkInTypeName;

    /**
     * 签到人员帐号
     */
    @CrmColumn(name = "user_name", length = 200, note = "签到人员帐号")
    private String userName;

    /**
     * 签到人员名称
     */
    @CrmColumn(name = "real_name", length = 200, note = "签到人员名称")
    private String realName;

    /**
     * 人员职位编码
     */
    @CrmColumn(name = "pos_code", length = 200, note = "人员职位编码")
    private String posCode;

    /**
     * 人员职位名称
     */
    @CrmColumn(name = "pos_name", length = 200, note = "人员职位名称")
    private String posName;

    /**
     * 人员组织编码
     */
    @CrmColumn(name = "org_code", length = 200, note = "人员组织编码")
    private String orgCode;

    /**
     * 人员组织名称
     */
    @CrmColumn(name = "org_name", length = 200, note = "人员组织名称")
    private String orgName;

    /**
     * 人员上级组织编码
     */
    @CrmColumn(name = "parent_org_code", length = 200, note = "人员上级组织编码")
    private String parentOrgCode;

    /**
     * 人员上级组织名称
     */
    @CrmColumn(name = "parent_org_name", length = 200, note = "人员上级组织名称")
    private String parentOrgName;

    /**
     * 打卡时间(HH:mm:ss)
     */
    @CrmColumn(name = "sign_time", length = 40, note = "打卡时间(HH:mm:ss)")
    private String signTime;

    /**
     * 打卡日期(YYYY-MM-DD)
     */
    @CrmColumn(name = "sign_date", length = 40, note = "打卡日期(YYYY-MM-DD)")
    private String signDate;

    /**
     * 打卡经度
     */
    @CrmColumn(name = "lng_in", length = 32, note = "打卡经度")
    private String lngIn;

    /**
     * 打卡纬度
     */
    @CrmColumn(name = "lat_in", length = 32, note = "打卡纬度")
    private String latIn;

    /**
     * 打卡地点
     */
    @CrmColumn(name = "sign_place", length = 128, note = "打卡地点")
    private String signPlace;

}
