package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组-签到图片实体类
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_sign_record_picture")
@CrmTable(name = "sfa_check_in_sign_record_picture", tableNote = "签到组-签到图片")
public class SfaCheckInSignRecordPictureEntity extends CrmExtTenEntity<SfaCheckInSignRecordPictureEntity> {

    /**
     * 签到记录id
     */
    @CrmColumn(name = "sign_record_id", length = 32, note = "签到记录id")
    private String signRecordId;

    /**
     * 照片路径(物理路径)
     */
    @CrmColumn(name = "pic_path", length = 100, note = "照片路径(物理路径)")
    private String picPath;

    /**
     * 照片地址
     */
    @CrmColumn(name = "pic_url", length = 100, note = "照片地址")
    private String picUrl;

    /**
     * 照片描述
     */
    @CrmColumn(name = "pic_desc", length = 100, note = "照片描述")
    private String picDesc;

}
