package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 打卡类型;实体类
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_type")
@CrmTable(name = "sfa_check_in_type", tableNote = "打卡类型")
public class SfaCheckInTypeEntity extends CrmExtTenEntity<SfaCheckInTypeEntity> {

    /**
     * 序号
     */
    @CrmColumn(name = "line_no", length = 32, note = "序号")
    private String lineNo;

    /**
     * 类型名称
     */
    @CrmColumn(name = "type_name", length = 128, note = "类型名称")
    private String typeName;

    /**
     * 是否拍照(Y是,N否)
     */
    @CrmColumn(name = "photograph", length = 8, note = "是否拍照(Y是,N否)")
    private String photograph;

    /**
     * 是否指定时间(Y是,N否)
     */
    @CrmColumn(name = "appoint_time", length = 8, note = "是否指定时间(Y是,N否)")
    private String appointTime;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_time", length = 32, note = "开始时间")
    private String beginTime;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_time", length = 32, note = "结束时间")
    private String endTime;

}
